# PinK Image Generator

AI-powered image generation extension for VS Code using Google Gemini/Imagen.

## Features

- 🎨 **Multi-turn Conversation**: Chat with AI to iteratively refine images
- 🖼️ **Image Generation**: Create images from text descriptions
- 🎯 **Aspect Ratio Control**: Choose from 1:1, 16:9, 9:16, 3:4, 4:3
- 💬 **MCP Server Support**: Works in VS Code OSS via Model Context Protocol
- 🔄 **Session Management**: Continue or reset conversations as needed
- 💾 **Auto-save**: Automatically saves to workspace assets folder

## Usage

### Via Chat

Use the `@generate-image` tool in VS Code Chat:

```
@generate-image Generate a beautiful sunset over mountains in 16:9 aspect ratio
```

### Via Command Palette

1. Press `Cmd+Shift+P` (macOS) or `Ctrl+Shift+P` (Windows/Linux)
2. Run `Generate Image`
3. Enter your image description

## Configuration

The extension requires a Google Gemini API Key.

1. Open VS Code Settings (`Cmd+,` or `Ctrl+,`)
2. Search for `pink-image-generator`
3. Enter your API Key in `Pink-image-generator: Gemini Key`

### Supported Models

- `gemini-3-pro-image-preview` (default)
- `gemini-2.5-flash-image`

### Supported Aspect Ratios

- `1:1` - Square (default)
- `16:9` - Landscape
- `9:16` - Portrait
- `3:4` - Vertical
- `4:3` - Horizontal

## Requirements

- VS Code 1.90.0 or higher
- Active workspace (for auto-save feature)

## Extension Settings

This extension contributes the following tool:

- `chatImage`: Generate and modify images through conversational AI

### Tool Parameters

- `prompt` (required): Your image description
- `images` (optional): Array of images (UUID, Base64, or file paths) for modification
- `model` (optional): AI model to use
- `aspectRatio` (optional): Image dimensions (1:1, 16:9, 9:16, 3:4, 4:3)
- `savePath` (optional): Custom save location
- `resetSession` (optional): Start a new conversation
- `includeBase64` (optional): Include base64 data in response

## How It Works

1. **In VS Code Extension Mode**: Images are saved to `<workspace>/assets/`
2. **In MCP Server Mode**: Returns base64 image data
3. **Multi-turn**: Maintains conversation context for iterative refinement

## Known Issues

- Image generation requires active Google Gemini API access
- First generation in a session may take longer

## Release Notes

### 0.0.1

Initial release:
- Multi-turn image generation
- Aspect ratio support
- MCP Server integration
- Auto-save to workspace

---

**Enjoy creating amazing images with AI!** 🎨
