"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.activate = activate;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const vscode = __importStar(require("vscode"));
/**
 * View type that uniquely identifies the Mermaid chat output renderer.
 */
const viewType = 'vscode.chatMermaidDiagram';
/**
 * Mime type used to identify Mermaid diagram data in chat output.
 */
const mime = 'text/vnd.mermaid';
function activate(context) {
    // Register tools
    context.subscriptions.push(vscode.lm.registerTool('renderMermaidDiagram', {
        invoke: async (options, _token) => {
            const sourceCode = options.input.markup;
            return writeMermaidToolOutput(sourceCode);
        },
    }));
    // Register the chat output renderer for Mermaid diagrams.
    // This will be invoked with the data generated by the tools.
    // It can also be invoked when rendering old Mermaid diagrams in the chat history.
    context.subscriptions.push(vscode.chat.registerChatOutputRenderer(viewType, {
        async renderChatOutput({ value }, webview, _ctx, _token) {
            const mermaidSource = new TextDecoder().decode(value);
            // Set the options for the webview
            const mediaRoot = vscode.Uri.joinPath(context.extensionUri, 'chat-webview-out');
            webview.options = {
                enableScripts: true,
                localResourceRoots: [mediaRoot],
            };
            // Set the HTML content for the webview
            const nonce = getNonce();
            const mermaidScript = vscode.Uri.joinPath(mediaRoot, 'index.js');
            webview.html = `
					<!DOCTYPE html>
					<html lang="en">

					<head>
						<meta charset="UTF-8">
						<meta name="viewport" content="width=device-width, initial-scale=1.0">
						<title>Mermaid Diagram</title>
						<meta http-equiv="Content-Security-Policy" content="default-src 'none'; script-src ${webview.cspSource} 'nonce-${nonce}'; style-src 'self' 'unsafe-inline';" />
					</head>

					<body>
						<pre class="mermaid">
							${escapeHtmlText(mermaidSource)}
						</pre>

						<script type="module" nonce="${nonce}" src="${webview.asWebviewUri(mermaidScript)}"></script>
					</body>
					</html>`;
        },
    }));
}
function writeMermaidToolOutput(sourceCode) {
    // Expose the source code as a tool result for the LM
    const result = new vscode.LanguageModelToolResult([
        new vscode.LanguageModelTextPart(sourceCode)
    ]);
    // And store custom data in the tool result details to indicate that a custom renderer should be used for it.
    // In this case we just store the source code as binary data.
    // Add cast to use proposed API
    result.toolResultDetails2 = {
        mime,
        value: new TextEncoder().encode(sourceCode),
    };
    return result;
}
function escapeHtmlText(str) {
    return str
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#39;');
}
function getNonce() {
    let text = '';
    const possible = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    for (let i = 0; i < 64; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
}
//# sourceMappingURL=extension.js.map