"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/extension/typescriptContext/serverPlugin/src/common/typescript.ts
function TS() {
  if (_ts === void 0) {
    throw new Error("tsserverlibrary not loaded yet");
  }
  return _ts;
}
var _ts, typescript_default;
var init_typescript = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/typescript.ts"() {
    "use strict";
    ((TS2) => {
      function install(ts9) {
        _ts = ts9;
      }
      TS2.install = install;
    })(TS || (TS = {}));
    typescript_default = TS;
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/protocol.ts
var CacheInfo, CachedContextItem, ContextItemReference, Trait, CodeSnippet, ContextItem, ErrorData, Timings, ComputeContextResponse;
var init_protocol = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/protocol.ts"() {
    "use strict";
    ((CacheInfo2) => {
      function has(item) {
        return item.cache !== void 0;
      }
      CacheInfo2.has = has;
    })(CacheInfo || (CacheInfo = {}));
    ((CachedContextItem2) => {
      function create3(key, sizeInChars) {
        return { key, sizeInChars };
      }
      CachedContextItem2.create = create3;
    })(CachedContextItem || (CachedContextItem = {}));
    ((ContextItemReference2) => {
      function create3(key) {
        return { kind: "reference" /* Reference */, key };
      }
      ContextItemReference2.create = create3;
    })(ContextItemReference || (ContextItemReference = {}));
    ((Trait2) => {
      function create3(traitKind, name, value) {
        return { kind: "trait" /* Trait */, key: createContextItemKey(traitKind), name, value };
      }
      Trait2.create = create3;
      function sizeInChars(trait) {
        return trait.name.length + trait.value.length;
      }
      Trait2.sizeInChars = sizeInChars;
      function createContextItemKey(traitKind) {
        return JSON.stringify({ k: "trait" /* Trait */, tk: traitKind }, void 0, 0);
      }
      Trait2.createContextItemKey = createContextItemKey;
    })(Trait || (Trait = {}));
    ((CodeSnippet2) => {
      function create3(key, fileName, additionalFileNames, value) {
        return { kind: "snippet" /* Snippet */, key, fileName, additionalFileNames, value };
      }
      CodeSnippet2.create = create3;
      function sizeInChars(snippet) {
        let result = snippet.value.length;
        result += snippet.fileName.length + 3;
        if (snippet.additionalFileNames !== void 0) {
          for (const fileName of snippet.additionalFileNames) {
            result += fileName.length + 3;
          }
        }
        return result;
      }
      CodeSnippet2.sizeInChars = sizeInChars;
    })(CodeSnippet || (CodeSnippet = {}));
    ((ContextItem2) => {
      function hasKey(item) {
        return item.key !== void 0;
      }
      ContextItem2.hasKey = hasKey;
      function sizeInChars(item) {
        switch (item.kind) {
          case "trait" /* Trait */:
            return Trait.sizeInChars(item);
          case "snippet" /* Snippet */:
            return CodeSnippet.sizeInChars(item);
          default:
            return 0;
        }
      }
      ContextItem2.sizeInChars = sizeInChars;
    })(ContextItem || (ContextItem = {}));
    ((ErrorData2) => {
      function create3(code, message) {
        return { code, message };
      }
      ErrorData2.create = create3;
    })(ErrorData || (ErrorData = {}));
    ((Timings2) => {
      function create3(totalTime, computeTime) {
        return { totalTime, computeTime };
      }
      Timings2.create = create3;
    })(Timings || (Timings = {}));
    ((ComputeContextResponse2) => {
      function isCancelled(response) {
        return response.type === "cancelled";
      }
      ComputeContextResponse2.isCancelled = isCancelled;
      function isOk(response) {
        return response.type === "response" && response.body.state !== void 0;
      }
      ComputeContextResponse2.isOk = isOk;
      function isError(response) {
        return response.type === "response" && response.body.error !== void 0;
      }
      ComputeContextResponse2.isError = isError;
    })(ComputeContextResponse || (ComputeContextResponse = {}));
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/types.ts
var ProgramContext, RecoverableError;
var init_types = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/types.ts"() {
    "use strict";
    ProgramContext = class {
      /**
       * The symbol is skipped if it has no declarations or if one declaration
       * comes from a default or external library.
       */
      getSymbolInfo(symbol) {
        const declarations = symbol.declarations;
        if (declarations === void 0 || declarations.length === 0) {
          return { skip: true };
        }
        let primary;
        let skipCount = 0;
        const program = this.getProgram();
        for (const declaration of declarations) {
          const sourceFile = declaration.getSourceFile();
          if (primary === void 0) {
            primary = sourceFile;
          }
          if (program.isSourceFileDefaultLibrary(sourceFile) || program.isSourceFileFromExternalLibrary(sourceFile)) {
            skipCount++;
          }
        }
        return skipCount > 0 ? { skip: true } : { skip: false, primary };
      }
      skipDeclaration(declaration, sourceFile = declaration.getSourceFile()) {
        const program = this.getProgram();
        return program.isSourceFileDefaultLibrary(sourceFile) || program.isSourceFileFromExternalLibrary(sourceFile);
      }
    };
    RecoverableError = class extends Error {
      static SourceFileNotFound = 1;
      static NodeNotFound = 2;
      static NodeKindMismatch = 3;
      static SymbolNotFound = 4;
      static NoDeclaration = 5;
      static NoProgram = 6;
      static NoSourceFile = 7;
      code;
      constructor(message, code) {
        super(message);
        this.code = code;
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/typescripts.ts
var require_typescripts = __commonJS({
  "src/extension/typescriptContext/serverPlugin/src/common/typescripts.ts"(exports2, module2) {
    "use strict";
    init_typescript();
    var ts9 = typescript_default();
    var EmptyIterator = function* () {
    }();
    var tss6;
    ((tss7) => {
      const its = ts9;
      tss7.getTokenAtPosition = its.getTokenAtPosition;
      tss7.getTouchingToken = its.getTouchingToken;
      tss7.getNameTable = its.getNameTable;
      tss7.findReferencedSymbols = its.findReferencedSymbols;
      tss7.getSymbolId = its.getSymbolId;
      function getRelevantTokens(sourceFile, position) {
        const token = tss7.getTokenAtPosition(sourceFile, position);
        if (token.kind === ts9.SyntaxKind.EndOfFileToken) {
          let current = token;
          let start = position;
          while (current.kind === ts9.SyntaxKind.EndOfFileToken && start > 0) {
            current = tss7.getTokenAtPosition(sourceFile, --start);
          }
          if (current.kind === ts9.SyntaxKind.EndOfFileToken) {
            return { token };
          } else {
            return { previous: current, token };
          }
        }
        const result = { token };
        let needsPrevious = true;
        if (position > token.getStart(sourceFile)) {
          result.touching = token;
          needsPrevious = false;
        } else if (position < token.getStart(sourceFile)) {
          let candidate = token.parent;
          while (candidate !== void 0) {
            if (position >= candidate.getStart(sourceFile)) {
              result.touching = candidate;
              break;
            }
            candidate = candidate.parent;
          }
        }
        if (needsPrevious) {
          let current = token;
          while (current.parent) {
            const children = Nodes2.getChildren(current.parent, sourceFile);
            const currentIndex = findNodeIndex(children, current);
            if (currentIndex > 0) {
              let previousNode = children[currentIndex - 1];
              let previousChildren = Nodes2.getChildren(previousNode, sourceFile);
              while (previousChildren.length > 0) {
                const lastChild = previousChildren[previousChildren.length - 1];
                if (lastChild.kind === ts9.SyntaxKind.EndOfFileToken) {
                  break;
                }
                previousNode = lastChild;
                previousChildren = Nodes2.getChildren(previousNode, sourceFile);
              }
              if (previousNode.kind !== ts9.SyntaxKind.EndOfFileToken) {
                result.previous = previousNode;
                break;
              }
            }
            current = current.parent;
          }
        }
        return result;
      }
      tss7.getRelevantTokens = getRelevantTokens;
      function findNodeIndex(nodes, target) {
        let left = 0;
        let right = nodes.length - 1;
        while (left <= right) {
          const mid = Math.floor((left + right) / 2);
          const midPos = nodes[mid].getStart();
          const targetPos = target.getStart();
          if (midPos === targetPos) {
            if (nodes[mid] === target) {
              return mid;
            }
            return -1;
          }
          if (midPos < targetPos) {
            left = mid + 1;
          } else {
            right = mid - 1;
          }
        }
        return -1;
      }
      let Programs;
      ((Programs2) => {
        function getKey(program) {
          const compilerOptions = program.getCompilerOptions();
          if (typeof compilerOptions.project === "string") {
            return compilerOptions.project;
          }
          const configFilePath = compilerOptions.configFilePath;
          return typeof configFilePath === "string" ? configFilePath : void 0;
        }
        Programs2.getKey = getKey;
      })(Programs = tss7.Programs || (tss7.Programs = {}));
      class CancellationTokenWithTimer2 {
        cancellationToken;
        end;
        constructor(cancellationToken, startTime, budget, isDebugging = false) {
          this.cancellationToken = isDebugging ? void 0 : cancellationToken;
          this.end = isDebugging ? Number.MAX_VALUE : startTime + budget;
        }
        isCancellationRequested() {
          if (this.cancellationToken && this.cancellationToken.isCancellationRequested()) {
            return true;
          }
          return Date.now() > this.end;
        }
        isTimedOut() {
          return Date.now() > this.end;
        }
        throwIfCancellationRequested() {
          if (this.isCancellationRequested()) {
            throw new ts9.OperationCanceledException();
          }
        }
      }
      tss7.CancellationTokenWithTimer = CancellationTokenWithTimer2;
      class NullCancellationToken {
        isCancellationRequested() {
          return false;
        }
        throwIfCancellationRequested() {
        }
      }
      tss7.NullCancellationToken = NullCancellationToken;
      let Nodes2;
      ((Nodes3) => {
        function getChildren(node, sourceFile) {
          if (ts9.isSourceFile(node)) {
            const children = node.getChildren(sourceFile);
            if (children.length > 0 && children[0].kind === ts9.SyntaxKind.SyntaxList) {
              return children[0].getChildren(sourceFile);
            } else {
              return node.statements;
            }
          } else {
            return node.getChildren(sourceFile);
          }
        }
        Nodes3.getChildren = getChildren;
        function getSymbol(node) {
          return node.symbol;
        }
        Nodes3.getSymbol = getSymbol;
        function getTypeName(node) {
          if (ts9.isTypeReferenceNode(node)) {
            return node.typeName.getText();
          }
          return void 0;
        }
        Nodes3.getTypeName = getTypeName;
        function getParentOfKind(node, kind) {
          let current = node;
          while (current !== void 0) {
            if (current.kind === kind) {
              return current;
            }
            current = current.parent;
          }
          return void 0;
        }
        Nodes3.getParentOfKind = getParentOfKind;
      })(Nodes2 = tss7.Nodes || (tss7.Nodes = {}));
      let Declarations2;
      ((Declarations3) => {
        function isPrivate(node) {
          const modifierFlags = ts9.getCombinedModifierFlags(node);
          return (modifierFlags & ts9.ModifierFlags.Private) !== 0;
        }
        Declarations3.isPrivate = isPrivate;
      })(Declarations2 = tss7.Declarations || (tss7.Declarations = {}));
      let TypeDeclarations;
      ((TypeDeclarations2) => {
        let Mode;
        ((Mode2) => {
          Mode2[Mode2["topLevel"] = 0] = "topLevel";
        })(Mode = TypeDeclarations2.Mode || (TypeDeclarations2.Mode = {}));
        function is(node) {
          const kind = node.kind;
          return kind === ts9.SyntaxKind.InterfaceDeclaration || kind === ts9.SyntaxKind.ClassDeclaration;
        }
        TypeDeclarations2.is = is;
        function entries(sourceFile, _mode = 0 /* topLevel */) {
          return fromStatements(sourceFile.statements);
        }
        TypeDeclarations2.entries = entries;
        function* fromStatements(statements) {
          for (const statement of statements) {
            if (ts9.isClassDeclaration(statement) || ts9.isInterfaceDeclaration(statement)) {
              yield statement;
            } else if (ts9.isModuleDeclaration(statement) && statement.body !== void 0 && ts9.isModuleBlock(statement.body)) {
              yield* fromStatements(statement.body.statements);
            }
          }
        }
      })(TypeDeclarations = tss7.TypeDeclarations || (tss7.TypeDeclarations = {}));
      let ClassDeclarations3;
      ((ClassDeclarations4) => {
        function getExtendsClause(classDeclaration) {
          const heritageClauses = classDeclaration.heritageClauses;
          if (heritageClauses === void 0) {
            return void 0;
          }
          return heritageClauses.find((h) => h.token === ts9.SyntaxKind.ExtendsKeyword);
        }
        ClassDeclarations4.getExtendsClause = getExtendsClause;
        function entries(sourceFile) {
          return fromStatements(sourceFile.statements);
        }
        ClassDeclarations4.entries = entries;
        function* fromStatements(statements) {
          for (const statement of statements) {
            if (ts9.isClassDeclaration(statement)) {
              yield statement;
            } else if (ts9.isModuleDeclaration(statement) && statement.body !== void 0 && ts9.isModuleBlock(statement.body)) {
              yield* fromStatements(statement.body.statements);
            }
          }
        }
        function fromSymbol(symbol) {
          if (!Symbols6.isClass(symbol)) {
            return void 0;
          }
          const declarations = symbol.getDeclarations();
          if (declarations === void 0) {
            return void 0;
          }
          for (const declaration of declarations) {
            if (ts9.isClassDeclaration(declaration)) {
              return declaration;
            }
          }
          return void 0;
        }
        ClassDeclarations4.fromSymbol = fromSymbol;
      })(ClassDeclarations3 = tss7.ClassDeclarations || (tss7.ClassDeclarations = {}));
      let Types2;
      ((Types3) => {
        function isIntersection(type) {
          return (type.flags & ts9.TypeFlags.Intersection) !== 0;
        }
        Types3.isIntersection = isIntersection;
        function isUnion(type) {
          return (type.flags & ts9.TypeFlags.Union) !== 0;
        }
        Types3.isUnion = isUnion;
        function getBaseTypes(type) {
          return type.getBaseTypes();
        }
        Types3.getBaseTypes = getBaseTypes;
        function getExtendsTypes(typeChecker, type) {
          const symbol = type.getSymbol();
          if (symbol === void 0) {
            return void 0;
          }
          const declarations = symbol.getDeclarations();
          if (declarations === void 0) {
            return void 0;
          }
          const result = [];
          for (const declaration of declarations) {
            if (ts9.isClassDeclaration(declaration)) {
              const heritageClauses = declaration.heritageClauses;
              if (heritageClauses !== void 0) {
                for (const heritageClause of heritageClauses) {
                  for (const type2 of heritageClause.types) {
                    result.push(typeChecker.getTypeAtLocation(type2.expression));
                  }
                }
              }
            }
          }
          return result;
        }
        Types3.getExtendsTypes = getExtendsTypes;
      })(Types2 = tss7.Types || (tss7.Types = {}));
      let Traversal2;
      ((Traversal3) => {
        Traversal3["depthFirst"] = "depthFirst";
        Traversal3["breadthFirst"] = "breadthFirst";
      })(Traversal2 = tss7.Traversal || (tss7.Traversal = {}));
      let InternalTraversal;
      ((InternalTraversal2) => {
        InternalTraversal2["breadthFirstOnly"] = "breadthFirstOnly";
      })(InternalTraversal || (InternalTraversal = {}));
      class ClassTraversal {
        start;
        mode;
        symbols;
        constructor(start, mode, symbols) {
          this.start = start;
          this.mode = mode;
          this.symbols = symbols;
        }
        isValid() {
          return Symbols6.isClass(this.start);
        }
        isValidDeclaration(declaration) {
          return ts9.isClassDeclaration(declaration);
        }
        *getDeclarations(sourceFile) {
          yield* ClassDeclarations3.entries(sourceFile);
        }
        isSubType(declaration, symbol) {
          return this.symbols.isSubClass(declaration, symbol);
        }
        with(start) {
          return new ClassTraversal(start, this.mode, this.symbols);
        }
      }
      class TypeTraversal {
        start;
        mode;
        symbols;
        constructor(start, mode, symbols) {
          this.start = start;
          this.mode = mode;
          this.symbols = symbols;
        }
        isValid() {
          return Symbols6.isClass(this.start) || Symbols6.isInterface(this.start) || Symbols6.isTypeAlias(this.start);
        }
        isValidDeclaration(declaration) {
          return TypeDeclarations.is(declaration) || ts9.isTypeAliasDeclaration(declaration);
        }
        *getDeclarations(sourceFile) {
          yield* TypeDeclarations.entries(sourceFile, 0 /* topLevel */);
        }
        isSubType(declaration, symbol) {
          return this.symbols.isSubType(declaration, symbol);
        }
        with(start) {
          return new TypeTraversal(start, this.mode, this.symbols);
        }
      }
      class Symbols6 {
        program;
        typeChecker;
        constructor(program) {
          this.program = program;
          this.typeChecker = program.getTypeChecker();
        }
        static Unknown = "unknown";
        static Undefined = "undefined";
        static None = "none";
        static getParent(symbol) {
          return symbol.parent;
        }
        static isConstructor(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.Constructor) !== 0;
        }
        static isGetAccessor(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.GetAccessor) !== 0;
        }
        static isSetAccessor(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.SetAccessor) !== 0;
        }
        static isMethod(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.Method) !== 0;
        }
        static isProperty(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.Property) !== 0;
        }
        static isClass(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.Class) !== 0;
        }
        static isObjectLiteral(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.ObjectLiteral) !== 0;
        }
        static isInterface(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.Interface) !== 0;
        }
        static isTypeAlias(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.TypeAlias) !== 0;
        }
        static isTypeParameter(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.TypeParameter) !== 0;
        }
        static isTypeLiteral(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.TypeLiteral) !== 0;
        }
        static isAlias(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.Alias) !== 0;
        }
        static isFunction(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.Function) !== 0;
        }
        static isValueModule(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.ValueModule) !== 0;
        }
        static isEnum(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.Enum) !== 0;
        }
        static isRegularEnum(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.RegularEnum) !== 0;
        }
        static isConstEnum(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.ConstEnum) !== 0;
        }
        static isSignature(symbol) {
          return symbol !== void 0 && (symbol.getFlags() & ts9.SymbolFlags.Signature) !== 0;
        }
        static hasModifierFlags(symbol, flags) {
          const declarations = symbol.declarations;
          if (declarations !== void 0) {
            for (const declaration of declarations) {
              const modifierFlags = ts9.getCombinedModifierFlags(declaration);
              if ((modifierFlags & flags) === 0) {
                return false;
              }
            }
          }
          return true;
        }
        static isAbstract(symbol) {
          return this.hasModifierFlags(symbol, ts9.ModifierFlags.Abstract);
        }
        static isStatic(symbol) {
          return this.hasModifierFlags(symbol, ts9.ModifierFlags.Static);
        }
        static isPrivate(symbol) {
          return this.hasModifierFlags(symbol, ts9.ModifierFlags.Private);
        }
        static internalSymbolNames;
        static isInternal(symbol) {
          if (this.internalSymbolNames === void 0) {
            this.internalSymbolNames = /* @__PURE__ */ new Set();
            for (const item in ts9.InternalSymbolName) {
              this.internalSymbolNames.add(ts9.InternalSymbolName[item]);
            }
          }
          return this.internalSymbolNames.has(symbol.escapedName);
        }
        static isSourceFile(symbol) {
          const declarations = symbol.getDeclarations();
          return declarations !== void 0 && declarations.length === 1 && ts9.isSourceFile(declarations[0]);
        }
        static fillSources(sources, symbol) {
          if (symbol.declarations === void 0) {
            return;
          }
          for (const declaration of symbol.declarations) {
            const sourceFile = declaration.getSourceFile();
            if (sourceFile !== void 0) {
              sources.add(sourceFile.fileName);
            }
          }
        }
        static getPrimarySourceFile(symbol) {
          const declarations = symbol.declarations;
          if (declarations === void 0 || declarations.length === 0) {
            return void 0;
          }
          return declarations[0].getSourceFile();
        }
        static getDeclaration(symbol, kind) {
          const declarations = symbol.getDeclarations();
          if (declarations === void 0 || declarations.length === 0) {
            return void 0;
          }
          for (const declaration of declarations) {
            if (declaration.kind === kind) {
              return declaration;
            }
          }
          return void 0;
        }
        static createKey(symbol, hashProvider) {
          const declarations = symbol.getDeclarations();
          if (declarations === void 0) {
            return void 0;
          }
          const fragments = [];
          for (const declaration of declarations) {
            const sourceFile = declaration.getSourceFile();
            fragments.push({
              f: sourceFile.fileName,
              s: declaration.getStart(),
              e: declaration.getEnd(),
              k: declaration.kind
            });
          }
          if (fragments.length > 1) {
            fragments.sort((a, b) => {
              let result = a.f < b.f ? -1 : a.f > b.f ? 1 : 0;
              if (result !== 0) {
                return result;
              }
              result = a.s - b.s;
              if (result !== 0) {
                return result;
              }
              result = a.e - b.e;
              if (result !== 0) {
                return result;
              }
              return a.k - b.k;
            });
          }
          const hash = hashProvider.createHash("md5");
          if ((symbol.flags & ts9.SymbolFlags.Transient) !== 0) {
            hash.update(JSON.stringify({ trans: true }, void 0, 0));
          }
          hash.update(JSON.stringify(fragments, void 0, 0));
          return hash.digest("base64");
        }
        /**
         * Creates a key for a symbol that takes the document's version into account. The key is used
         * on the server side. It ensures that the key changes when the document changes.
         * @param symbol The symbol to create the key for.
         * @param versionProvider Provides the script version for a source file.
         * @param hashProvider Provides a hash function to create the key.
         * @returns A versioned key for the symbol or `undefined` if the key could not be created.
         */
        static createVersionedKey(symbol, context) {
          const declarations = symbol.getDeclarations();
          if (declarations === void 0) {
            return void 0;
          }
          const fragments = [];
          for (const declaration of declarations) {
            const sourceFile = declaration.getSourceFile();
            const scriptVersion = context.getScriptVersion(sourceFile);
            if (scriptVersion === void 0) {
              return void 0;
            }
            fragments.push({
              f: sourceFile.fileName,
              v: scriptVersion,
              s: declaration.getStart(),
              e: declaration.getEnd(),
              k: declaration.kind
            });
          }
          if (fragments.length > 1) {
            fragments.sort((a, b) => {
              let result = a.f < b.f ? -1 : a.f > b.f ? 1 : 0;
              if (result !== 0) {
                return result;
              }
              result = a.v < b.v ? -1 : a.v > b.v ? 1 : 0;
              if (result !== 0) {
                return result;
              }
              result = a.s - b.s;
              if (result !== 0) {
                return result;
              }
              result = a.e - b.e;
              if (result !== 0) {
                return result;
              }
              return a.k - b.k;
            });
          }
          const hash = context.host.createHash("md5");
          if ((symbol.flags & ts9.SymbolFlags.Transient) !== 0) {
            hash.update(JSON.stringify({ trans: true }, void 0, 0));
          }
          hash.update(JSON.stringify(fragments, void 0, 0));
          return hash.digest("base64");
        }
        getFullyQualifiedSymbolName(symbol) {
          const declarations = symbol.getDeclarations();
          if (declarations === void 0 || declarations.length === 0) {
            return void 0;
          }
          const sourceFile = declarations[0].getSourceFile();
          for (let i = 1; i < declarations.length; i++) {
            const otherSourceFile = declarations[i].getSourceFile();
            if (otherSourceFile !== sourceFile) {
              return void 0;
            }
          }
          if (this.getSymbolAtLocation(sourceFile) === void 0) {
            return void 0;
          }
          const parts = [];
          let current = symbol;
          while (current !== void 0) {
            const declarations2 = current.declarations;
            if (declarations2 === void 0 || declarations2.length === 0) {
              return void 0;
            }
            if (declarations2.length === 1 && ts9.isSourceFile(declarations2[0])) {
              break;
            }
            parts.push(this.getExportSymbolName(current));
            current = Symbols6.getParent(current);
          }
          return parts.length === 0 ? void 0 : `${parts.reverse().join(".")}`;
        }
        static escapeRegExp = new RegExp("\\.", "g");
        getExportSymbolName(symbol) {
          let escapedName = symbol.getEscapedName();
          if (escapedName.charAt(0) === '"' || escapedName.charAt(0) === "'") {
            escapedName = escapedName.substr(1, escapedName.length - 2);
          }
          escapedName = escapedName.replace(Symbols6.escapeRegExp, "..");
          return escapedName;
        }
        getProgram() {
          return this.program;
        }
        getTypeChecker() {
          return this.typeChecker;
        }
        getSymbolAtLocation(node) {
          let result = this.typeChecker.getSymbolAtLocation(node);
          if (result === void 0) {
            result = Nodes2.getSymbol(node);
          }
          return result;
        }
        getExtendsSymbol(symbol) {
          const declarations = symbol.declarations;
          if (declarations === void 0) {
            return [void 0, void 0];
          }
          for (const declaration of declarations) {
            if (ts9.isClassDeclaration(declaration)) {
              const heritageClauses = declaration.heritageClauses;
              if (heritageClauses !== void 0) {
                for (const heritageClause of heritageClauses) {
                  if (heritageClause.token === ts9.SyntaxKind.ExtendsKeyword) {
                    const extendsNode = heritageClause.types[0]?.expression;
                    let candidate = this.typeChecker.getSymbolAtLocation(extendsNode);
                    if (Symbols6.isAlias(candidate)) {
                      candidate = this.typeChecker.getAliasedSymbol(candidate);
                    }
                    if (Symbols6.isClass(candidate)) {
                      return [candidate, extendsNode.getText()];
                    }
                  }
                }
              }
            }
          }
          return [void 0, void 0];
        }
        getDirectSuperSymbols(symbol) {
          const declarations = symbol.declarations;
          if (declarations === void 0) {
            return void 0;
          }
          const result = {};
          for (const declaration of declarations) {
            if (ts9.isClassDeclaration(declaration)) {
              const heritageClauses = declaration.heritageClauses;
              if (heritageClauses !== void 0) {
                for (const heritageClause of heritageClauses) {
                  const extendsNode = heritageClause.types[0]?.expression;
                  let candidate = this.typeChecker.getSymbolAtLocation(extendsNode);
                  if (Symbols6.isAlias(candidate)) {
                    candidate = this.typeChecker.getAliasedSymbol(candidate);
                  }
                  if (heritageClause.token === ts9.SyntaxKind.ExtendsKeyword) {
                    if (Symbols6.isClass(candidate)) {
                      result.extends = { symbol: candidate, name: extendsNode.getText() };
                    }
                  } else if (heritageClause.token === ts9.SyntaxKind.ImplementsKeyword) {
                    if (Symbols6.isInterface(candidate)) {
                      if (result.implements === void 0) {
                        result.implements = [];
                      }
                      result.implements.push({ symbol: candidate, name: extendsNode.getText() });
                    }
                  }
                }
              }
            }
          }
          return result;
        }
        getAliasedSymbolAtLocation(node) {
          const symbol = this.getSymbolAtLocation(node);
          if (symbol === void 0) {
            return void 0;
          }
          if (Symbols6.isAlias(symbol)) {
            return this.typeChecker.getAliasedSymbol(symbol);
          }
          return symbol;
        }
        getLeafSymbolAtLocation(node) {
          const symbol = this.getSymbolAtLocation(node);
          if (symbol === void 0) {
            return void 0;
          }
          return this.getLeafSymbol(symbol);
        }
        getSymbolAtTypeNodeLocation(node) {
          if (ts9.isTypeReferenceNode(node)) {
            return this.getLeafSymbolAtLocation(node.typeName);
          } else if (ts9.isTypeLiteralNode(node)) {
            return this.getLeafSymbolAtLocation(node);
          } else {
            return this.getLeafSymbolAtLocation(node);
          }
        }
        getAliasedSymbol(symbol) {
          return Symbols6.isAlias(symbol) ? this.typeChecker.getAliasedSymbol(symbol) : symbol;
        }
        getLeafSymbol(symbol) {
          let count = 0;
          while (Symbols6.isAlias(symbol) && count++ < 10) {
            symbol = this.typeChecker.getAliasedSymbol(symbol);
          }
          while (Symbols6.isTypeAlias(symbol) && count++ < 10) {
            const declarations = symbol.declarations;
            if (declarations === void 0 || declarations.length !== 1) {
              break;
            }
            const declaration = declarations[0];
            if (!ts9.isTypeAliasDeclaration(declaration)) {
              break;
            }
            const typeSymbol = this.getSymbolAtLocation(declaration.type);
            if (typeSymbol === void 0) {
              break;
            }
            symbol = typeSymbol;
          }
          return symbol;
        }
        getAllSuperTypes(symbol, traversal = "depthFirst" /* depthFirst */) {
          return this._getAllSuperTypes(symbol, traversal, /* @__PURE__ */ new Set(), false);
        }
        getAllSuperTypesWithPath(symbol, traversal = "depthFirst" /* depthFirst */) {
          return this._getAllSuperTypes(symbol, traversal, /* @__PURE__ */ new Set(), true);
        }
        getDirectSuperTypes(symbol) {
          return this._getAllSuperTypes(symbol, "breadthFirstOnly" /* breadthFirstOnly */, /* @__PURE__ */ new Set(), false);
        }
        *_getAllSuperTypes(start, traversal, seen, includePath) {
          const queue = [start];
          while (queue.length > 0) {
            let symbol = queue.pop();
            if (Symbols6.isAlias(symbol)) {
              seen.add(symbol);
              symbol = this.typeChecker.getAliasedSymbol(symbol);
            }
            if (Symbols6.isClass(symbol) || Symbols6.isInterface(symbol)) {
              const declarations = symbol.declarations;
              if (declarations === void 0) {
                return;
              }
              for (const declaration of declarations) {
                let heritageClauses;
                if (ts9.isClassDeclaration(declaration)) {
                  heritageClauses = declaration.heritageClauses;
                } else if (ts9.isInterfaceDeclaration(declaration)) {
                  heritageClauses = declaration.heritageClauses;
                }
                if (heritageClauses === void 0) {
                  continue;
                }
                for (const heritageClause of heritageClauses) {
                  for (const type of heritageClause.types) {
                    const superType = this.getAliasedSymbolAtLocation(type.expression);
                    if (superType !== void 0 && !seen.has(superType)) {
                      seen.add(superType);
                      yield includePath ? [symbol, superType] : superType;
                      if (traversal === "depthFirst" /* depthFirst */) {
                        yield* this._getAllSuperTypes(superType, traversal, seen, includePath);
                      } else if (traversal === "breadthFirst" /* breadthFirst */) {
                        queue.push(superType);
                      }
                    }
                  }
                }
              }
            } else if (Symbols6.isTypeAlias(symbol)) {
              const declarations = symbol.declarations;
              if (declarations === void 0) {
                return;
              }
              for (const declaration of declarations) {
                if (ts9.isTypeAliasDeclaration(declaration)) {
                  const type = declaration.type;
                  if (ts9.isTypeLiteralNode(type)) {
                    const superType = this.getAliasedSymbolAtLocation(type);
                    if (superType !== void 0 && !seen.has(superType)) {
                      seen.add(superType);
                      yield includePath ? [symbol, superType] : superType;
                    }
                  } else if (ts9.isTypeReferenceNode(type)) {
                    const superType = this.getAliasedSymbolAtLocation(type.typeName);
                    if (superType !== void 0 && !seen.has(superType)) {
                      seen.add(superType);
                      yield includePath ? [symbol, superType] : superType;
                      if (traversal === "depthFirst" /* depthFirst */) {
                        yield* this._getAllSuperTypes(superType, traversal, seen, includePath);
                      } else if (traversal === "breadthFirst" /* breadthFirst */) {
                        queue.push(superType);
                      }
                    }
                  } else if (ts9.isIntersectionTypeNode(type)) {
                    for (const item of type.types) {
                      const superType = this.getSymbolAtTypeNodeLocation(item);
                      if (superType !== void 0 && !seen.has(superType)) {
                        if (Symbols6.isTypeLiteral(superType)) {
                          seen.add(superType);
                          yield includePath ? [symbol, superType] : superType;
                        } else if (Symbols6.isTypeAlias(superType)) {
                          seen.add(superType);
                          if (traversal === "depthFirst" /* depthFirst */) {
                            yield* this._getAllSuperTypes(superType, traversal, seen, includePath);
                          } else if (traversal === "breadthFirst" /* breadthFirst */) {
                            queue.push(superType);
                          }
                        } else {
                          seen.add(superType);
                          yield includePath ? [symbol, superType] : superType;
                          if (traversal === "depthFirst" /* depthFirst */) {
                            yield* this._getAllSuperTypes(superType, traversal, seen, includePath);
                          } else if (traversal === "breadthFirst" /* breadthFirst */) {
                            queue.push(superType);
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        getAllSuperClasses(symbol) {
          return this._getAllSuperClasses(symbol, /* @__PURE__ */ new Set());
        }
        *_getAllSuperClasses(symbol, seen) {
          if (!Symbols6.isClass(symbol)) {
            return;
          }
          const queue = [symbol];
          while (queue.length > 0) {
            const symbol2 = queue.pop();
            const declarations = symbol2.declarations;
            if (declarations === void 0) {
              continue;
            }
            for (const declaration of declarations) {
              if (!ts9.isClassDeclaration(declaration)) {
                continue;
              }
              const heritageClauses = declaration.heritageClauses;
              if (heritageClauses === void 0) {
                continue;
              }
              for (const heritageClause of heritageClauses) {
                if (heritageClause.token !== ts9.SyntaxKind.ExtendsKeyword || heritageClause.types.length < 1) {
                  continue;
                }
                const type = heritageClause.types[0];
                const superClass = this.getAliasedSymbolAtLocation(type.expression);
                if (superClass !== void 0 && !seen.has(superClass)) {
                  seen.add(superClass);
                  yield superClass;
                  queue.push(superClass);
                }
              }
            }
          }
        }
        isSubType(declaration, symbol) {
          if (declaration.heritageClauses === void 0) {
            return false;
          }
          for (const heritageClause of declaration.heritageClauses) {
            for (const type of heritageClause.types) {
              const superType = this.getAliasedSymbolAtLocation(type.expression);
              if (superType !== void 0 && superType === symbol) {
                return true;
              }
            }
          }
          return false;
        }
        isSubClass(declaration, symbol) {
          if (declaration.heritageClauses === void 0) {
            return false;
          }
          for (const heritageClause of declaration.heritageClauses) {
            if (heritageClause.token !== ts9.SyntaxKind.ExtendsKeyword) {
              continue;
            }
            if (heritageClause.types.length < 1) {
              return false;
            }
            const superType = this.getAliasedSymbolAtLocation(heritageClause.types[0].expression);
            if (superType !== void 0 && superType === symbol) {
              return true;
            }
          }
          return false;
        }
        getDirectSubTypes(start, preferredSourceFiles, stateProvider, token) {
          const traversal = Symbols6.isClass(start) ? new ClassTraversal(start, "breadthFirstOnly" /* breadthFirstOnly */, this) : Symbols6.isInterface(start) || Symbols6.isTypeAlias(start) ? new TypeTraversal(start, "breadthFirstOnly" /* breadthFirstOnly */, this) : void 0;
          if (traversal === void 0) {
            return EmptyIterator;
          }
          return this._getAllSubTypes(traversal, preferredSourceFiles, stateProvider, /* @__PURE__ */ new Set(), token);
        }
        getAllSubTypes(start, traversal = "depthFirst" /* depthFirst */, preferredSourceFiles, stateProvider, token) {
          const nt = Symbols6.isClass(start) ? new ClassTraversal(start, traversal, this) : Symbols6.isInterface(start) || Symbols6.isTypeAlias(start) ? new TypeTraversal(start, traversal, this) : void 0;
          if (nt === void 0) {
            return EmptyIterator;
          }
          return this._getAllSubTypes(nt, preferredSourceFiles, stateProvider, /* @__PURE__ */ new Set(), token);
        }
        *_getAllSubTypes(traversal, preferredSourceFiles, stateProvider, seen, token) {
          if (!traversal.isValid()) {
            return;
          }
          const queue = [traversal.start];
          while (queue.length > 0) {
            const current = queue.pop();
            const declarations = current.declarations;
            if (declarations === void 0 || declarations.length === 0) {
              return;
            }
            for (const declaration of declarations) {
              if (!traversal.isValidDeclaration(declaration)) {
                continue;
              }
              const referencedBy = new ReferencedByVisitor2(this.program, declaration.getSourceFile(), preferredSourceFiles, stateProvider, token);
              for (const sourceFile of referencedBy) {
                for (const typeDeclaration of traversal.getDeclarations(sourceFile)) {
                  const symbol = this.getAliasedSymbolAtLocation(typeDeclaration.name ? typeDeclaration.name : typeDeclaration);
                  if (symbol === void 0 || seen.has(symbol)) {
                    continue;
                  }
                  if (traversal.isSubType(typeDeclaration, current)) {
                    seen.add(symbol);
                    yield symbol;
                    if (traversal.mode === "depthFirst" /* depthFirst */) {
                      yield* this._getAllSubTypes(traversal.with(symbol), preferredSourceFiles, stateProvider, seen, token);
                    } else if (traversal.mode === "breadthFirst" /* breadthFirst */) {
                      queue.push(symbol);
                    }
                  }
                }
              }
            }
          }
        }
        getMemberStatistic(symbol) {
          const abstractMembers = /* @__PURE__ */ new Set();
          const concreteMembers = /* @__PURE__ */ new Set();
          Symbols6._getMemberStatistic(abstractMembers, concreteMembers, symbol);
          for (const superType of this.getAllSuperTypes(symbol)) {
            Symbols6._getMemberStatistic(abstractMembers, concreteMembers, superType);
          }
          return { abstract: abstractMembers, concrete: concreteMembers };
        }
        static _getMemberStatistic(abstractMembers, concreteMembers, symbol) {
          if (Symbols6.isClass(symbol)) {
            const declarations = symbol.declarations;
            if (declarations === void 0) {
              return;
            }
            for (const declaration of declarations) {
              if (ts9.isClassDeclaration(declaration)) {
                for (const member of declaration.members) {
                  if (ts9.isMethodDeclaration(member) || ts9.isGetAccessorDeclaration(member) || ts9.isSetAccessorDeclaration(member) || ts9.isPropertyDeclaration(member)) {
                    const name = member.name.getText();
                    if (Symbols6.includesAbstract(member.modifiers) && !concreteMembers.has(name)) {
                      abstractMembers.add(name);
                    } else {
                      concreteMembers.add(name);
                    }
                  } else if (ts9.isIndexSignatureDeclaration(member)) {
                    if (Symbols6.includesAbstract(member.modifiers) && !concreteMembers.has("[]")) {
                      abstractMembers.add("[]");
                    } else {
                      concreteMembers.add("[]");
                    }
                  }
                }
              }
            }
          } else if (Symbols6.isInterface(symbol) || Symbols6.isTypeLiteral(symbol)) {
            if (symbol.members !== void 0) {
              for (const member of symbol.members.values()) {
                if (!concreteMembers.has(member.name)) {
                  abstractMembers.add(member.name);
                }
              }
            }
          }
        }
        static includesAbstract(modifiers) {
          if (modifiers === void 0) {
            return false;
          }
          return modifiers.some((m) => m.kind === ts9.SyntaxKind.AbstractKeyword);
        }
      }
      tss7.Symbols = Symbols6;
      let Sessions2;
      ((Sessions3) => {
        function getProjectService(session) {
          return session.projectService;
        }
        Sessions3.getProjectService = getProjectService;
        function getFileAndProject(session, args) {
          const internal = session;
          if (typeof internal.getFileAndProject !== "function") {
            return void 0;
          }
          return internal.getFileAndProject(args);
        }
        Sessions3.getFileAndProject = getFileAndProject;
        function getPositionInFile(session, args, file) {
          const internal = session;
          if (typeof internal.getPositionInFile !== "function") {
            return void 0;
          }
          return internal.getPositionInFile(args, file);
        }
        Sessions3.getPositionInFile = getPositionInFile;
      })(Sessions2 = tss7.Sessions || (tss7.Sessions = {}));
      function isExternalModuleImportEquals(eq) {
        return eq.moduleReference.kind === ts9.SyntaxKind.ExternalModuleReference && eq.moduleReference.expression.kind === ts9.SyntaxKind.StringLiteral;
      }
      class ImportedByState2 {
        key;
        traversed;
        complete;
        outdated;
        importedBy;
        outdatedImportedBy;
        constructor(key) {
          this.key = key;
          this.complete = false;
          this.outdated = false;
          this.traversed = /* @__PURE__ */ new Set();
          this.importedBy = /* @__PURE__ */ new Map();
          this.outdatedImportedBy = void 0;
        }
        isComplete() {
          return this.complete;
        }
        markComplete() {
          this.complete = true;
          this.outdated = false;
          this.outdatedImportedBy = void 0;
        }
        addTraversed(sourceFile) {
          this.traversed.add(sourceFile.fileName);
        }
        isTraversed(sourceFile) {
          return this.traversed.has(sourceFile.fileName);
        }
        hasTraversed() {
          return this.traversed.size > 0;
        }
        imports(source, imports) {
          let values = this.importedBy.get(imports.fileName);
          if (values === void 0) {
            values = /* @__PURE__ */ new Set();
            this.importedBy.set(imports.fileName, values);
          }
          values.add(source.fileName);
        }
        getImportedBy(source, considerOutdated) {
          let importedBy = this.importedBy.get(source.fileName);
          if (importedBy === void 0 && considerOutdated) {
            importedBy = this.outdatedImportedBy?.get(source.fileName);
          }
          return importedBy === void 0 ? EmptyIterator : importedBy.values();
        }
        markAsOutdated() {
          this.outdated = true;
          this.outdatedImportedBy = this.importedBy;
          this.importedBy = /* @__PURE__ */ new Map();
        }
        isOutdated() {
          return this.outdated;
        }
      }
      tss7.ImportedByState = ImportedByState2;
      class ReferencedByVisitor2 {
        program;
        sourceFile;
        preferredSourceFiles;
        token;
        importedByState;
        constructor(program, sourceFile, preferredSourceFiles, stateProvider, token) {
          this.program = program;
          this.sourceFile = sourceFile;
          this.preferredSourceFiles = preferredSourceFiles;
          this.token = token;
          const programKey = tss7.Programs.getKey(program);
          this.importedByState = programKey !== void 0 ? stateProvider.getImportedByState(programKey) : void 0;
        }
        getSourceFile(fileName) {
          return this.program.getSourceFile(fileName);
        }
        [Symbol.iterator]() {
          return this.entries();
        }
        *entries() {
          this.token.throwIfCancellationRequested();
          const program = this.program;
          if (this.importedByState !== void 0) {
            for (const fileName of this.importedByState.getImportedBy(this.sourceFile, true)) {
              this.token.throwIfCancellationRequested();
              const sourceFile = this.getSourceFile(fileName);
              if (sourceFile !== void 0 && !this.skipSourceFile(program, sourceFile)) {
                yield sourceFile;
              }
            }
            if (this.importedByState.isComplete() && !this.importedByState.isOutdated()) {
              return;
            }
          }
          function isAmbientModuleDeclaration(node) {
            return node.kind === ts9.SyntaxKind.ModuleDeclaration && node.name.kind === ts9.SyntaxKind.StringLiteral;
          }
          function getUnderlyingSourceFileFromImport(checker2, node) {
            const importedSymbol = checker2.getSymbolAtLocation(node);
            if (importedSymbol === void 0 || !Symbols6.isSourceFile(importedSymbol)) {
              return void 0;
            }
            return importedSymbol.declarations[0];
          }
          const checker = program.getTypeChecker();
          const sourceFileSymbolToCheck = checker.getSymbolAtLocation(this.sourceFile);
          if (sourceFileSymbolToCheck === void 0) {
            return;
          }
          for (const sourceFile of this.allSourceFiles()) {
            this.token.throwIfCancellationRequested();
            if (this.sourceFile === sourceFile) {
              yield sourceFile;
              continue;
            }
            if (this.skipSourceFile(program, sourceFile)) {
              continue;
            }
            if (sourceFile.externalModuleIndicator && sourceFile.imports !== void 0) {
              for (let i = 0; i < sourceFile.imports.length; i++) {
                this.token.throwIfCancellationRequested();
                const importedSymbol = checker.getSymbolAtLocation(sourceFile.imports[i]);
                if (importedSymbol === sourceFileSymbolToCheck) {
                  if (this.importedByState !== void 0) {
                    this.importedByState.imports(sourceFile, this.sourceFile);
                    for (let r = i + 1; r < sourceFile.imports.length; r++) {
                      const importedSourceFile = getUnderlyingSourceFileFromImport(checker, sourceFile.imports[i]);
                      if (importedSourceFile !== void 0 && !this.skipSourceFile(program, importedSourceFile)) {
                        this.importedByState?.imports(sourceFile, importedSourceFile);
                      }
                    }
                  }
                  yield sourceFile;
                  break;
                } else if (importedSymbol !== void 0 && Symbols6.isSourceFile(importedSymbol)) {
                  const importedSourceFile = importedSymbol.declarations[0];
                  if (!this.skipSourceFile(program, importedSourceFile)) {
                    this.importedByState?.imports(sourceFile, importedSourceFile);
                  }
                }
              }
            } else {
              const sf = sourceFile;
              const statements = sf.kind === ts9.SyntaxKind.SourceFile ? sf.statements : sf.body.statements;
              const imports = (statement) => {
                switch (statement.kind) {
                  case ts9.SyntaxKind.ExportDeclaration:
                  case ts9.SyntaxKind.ImportDeclaration: {
                    const decl = statement;
                    if (decl.moduleSpecifier && ts9.isStringLiteral(decl.moduleSpecifier)) {
                      const importedSourceFileSymbol = checker.getSymbolAtLocation(decl.moduleSpecifier);
                      if (importedSourceFileSymbol === sourceFileSymbolToCheck) {
                        return true;
                      }
                    }
                    break;
                  }
                  case ts9.SyntaxKind.ImportEqualsDeclaration: {
                    const decl = statement;
                    if (isExternalModuleImportEquals(decl)) {
                      const importedSourceFileSymbol = checker.getSymbolAtLocation(decl.moduleReference.expression);
                      if (importedSourceFileSymbol === sourceFileSymbolToCheck) {
                        return true;
                      }
                    }
                    break;
                  }
                }
                return false;
              };
              loop: for (const statement of statements) {
                this.token.throwIfCancellationRequested();
                if (imports(statement)) {
                  this.importedByState?.imports(sourceFile, this.sourceFile);
                  yield sourceFile;
                  break loop;
                } else if (isAmbientModuleDeclaration(statement)) {
                  const moduleStatements = statement.body && statement.body.statements;
                  if (moduleStatements !== void 0) {
                    for (const moduleStatement of moduleStatements) {
                      if (imports(moduleStatement)) {
                        this.importedByState?.imports(sourceFile, this.sourceFile);
                        yield sourceFile;
                        break loop;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        skipSourceFile(program, sourceFile) {
          return program.isSourceFileDefaultLibrary(sourceFile) || program.isSourceFileFromExternalLibrary(sourceFile) || sourceFile.isDeclarationFile;
        }
        *allSourceFiles() {
          if (this.importedByState === void 0) {
            if (this.preferredSourceFiles !== void 0) {
              yield* this.preferredSourceFiles;
            }
            yield* this.program.getSourceFiles();
          } else {
            if (this.preferredSourceFiles !== void 0) {
              for (const sourceFile of this.preferredSourceFiles) {
                if (!this.importedByState.isTraversed(sourceFile)) {
                  this.importedByState.addTraversed(sourceFile);
                  yield sourceFile;
                }
              }
              for (const sourceFile of this.program.getSourceFiles()) {
                if (!this.importedByState.isTraversed(sourceFile)) {
                  this.importedByState.addTraversed(sourceFile);
                  yield sourceFile;
                }
              }
            }
            this.importedByState.markComplete();
          }
        }
      }
      tss7.ReferencedByVisitor = ReferencedByVisitor2;
      let StableSyntaxKinds;
      ((StableSyntaxKinds2) => {
        const KindMap = /* @__PURE__ */ new Map([
          [ts9.SyntaxKind.Unknown, 0],
          [ts9.SyntaxKind.EndOfFileToken, 1],
          [ts9.SyntaxKind.SingleLineCommentTrivia, 2],
          [ts9.SyntaxKind.MultiLineCommentTrivia, 3],
          [ts9.SyntaxKind.NewLineTrivia, 4],
          [ts9.SyntaxKind.WhitespaceTrivia, 5],
          [ts9.SyntaxKind.ShebangTrivia, 6],
          [ts9.SyntaxKind.ConflictMarkerTrivia, 7],
          [ts9.SyntaxKind.NonTextFileMarkerTrivia, 8],
          [ts9.SyntaxKind.NumericLiteral, 9],
          [ts9.SyntaxKind.BigIntLiteral, 10],
          [ts9.SyntaxKind.StringLiteral, 11],
          [ts9.SyntaxKind.JsxText, 12],
          [ts9.SyntaxKind.JsxTextAllWhiteSpaces, 13],
          [ts9.SyntaxKind.RegularExpressionLiteral, 14],
          [ts9.SyntaxKind.NoSubstitutionTemplateLiteral, 15],
          [ts9.SyntaxKind.TemplateHead, 16],
          [ts9.SyntaxKind.TemplateMiddle, 17],
          [ts9.SyntaxKind.TemplateTail, 18],
          [ts9.SyntaxKind.OpenBraceToken, 19],
          [ts9.SyntaxKind.CloseBraceToken, 20],
          [ts9.SyntaxKind.OpenParenToken, 21],
          [ts9.SyntaxKind.CloseParenToken, 22],
          [ts9.SyntaxKind.OpenBracketToken, 23],
          [ts9.SyntaxKind.CloseBracketToken, 24],
          [ts9.SyntaxKind.DotToken, 25],
          [ts9.SyntaxKind.DotDotDotToken, 26],
          [ts9.SyntaxKind.SemicolonToken, 27],
          [ts9.SyntaxKind.CommaToken, 28],
          [ts9.SyntaxKind.QuestionDotToken, 29],
          [ts9.SyntaxKind.LessThanToken, 30],
          [ts9.SyntaxKind.LessThanSlashToken, 31],
          [ts9.SyntaxKind.GreaterThanToken, 32],
          [ts9.SyntaxKind.LessThanEqualsToken, 33],
          [ts9.SyntaxKind.GreaterThanEqualsToken, 34],
          [ts9.SyntaxKind.EqualsEqualsToken, 35],
          [ts9.SyntaxKind.ExclamationEqualsToken, 36],
          [ts9.SyntaxKind.EqualsEqualsEqualsToken, 37],
          [ts9.SyntaxKind.ExclamationEqualsEqualsToken, 38],
          [ts9.SyntaxKind.EqualsGreaterThanToken, 39],
          [ts9.SyntaxKind.PlusToken, 40],
          [ts9.SyntaxKind.MinusToken, 41],
          [ts9.SyntaxKind.AsteriskToken, 42],
          [ts9.SyntaxKind.AsteriskAsteriskToken, 43],
          [ts9.SyntaxKind.SlashToken, 44],
          [ts9.SyntaxKind.PercentToken, 45],
          [ts9.SyntaxKind.PlusPlusToken, 46],
          [ts9.SyntaxKind.MinusMinusToken, 47],
          [ts9.SyntaxKind.LessThanLessThanToken, 48],
          [ts9.SyntaxKind.GreaterThanGreaterThanToken, 49],
          [ts9.SyntaxKind.GreaterThanGreaterThanGreaterThanToken, 50],
          [ts9.SyntaxKind.AmpersandToken, 51],
          [ts9.SyntaxKind.BarToken, 52],
          [ts9.SyntaxKind.CaretToken, 53],
          [ts9.SyntaxKind.ExclamationToken, 54],
          [ts9.SyntaxKind.TildeToken, 55],
          [ts9.SyntaxKind.AmpersandAmpersandToken, 56],
          [ts9.SyntaxKind.BarBarToken, 57],
          [ts9.SyntaxKind.QuestionToken, 58],
          [ts9.SyntaxKind.ColonToken, 59],
          [ts9.SyntaxKind.AtToken, 60],
          [ts9.SyntaxKind.QuestionQuestionToken, 61],
          [ts9.SyntaxKind.BacktickToken, 62],
          [ts9.SyntaxKind.HashToken, 63],
          [ts9.SyntaxKind.EqualsToken, 64],
          [ts9.SyntaxKind.PlusEqualsToken, 65],
          [ts9.SyntaxKind.MinusEqualsToken, 66],
          [ts9.SyntaxKind.AsteriskEqualsToken, 67],
          [ts9.SyntaxKind.AsteriskAsteriskEqualsToken, 68],
          [ts9.SyntaxKind.SlashEqualsToken, 69],
          [ts9.SyntaxKind.PercentEqualsToken, 70],
          [ts9.SyntaxKind.LessThanLessThanEqualsToken, 71],
          [ts9.SyntaxKind.GreaterThanGreaterThanEqualsToken, 72],
          [ts9.SyntaxKind.GreaterThanGreaterThanGreaterThanEqualsToken, 73],
          [ts9.SyntaxKind.AmpersandEqualsToken, 74],
          [ts9.SyntaxKind.BarEqualsToken, 75],
          [ts9.SyntaxKind.BarBarEqualsToken, 76],
          [ts9.SyntaxKind.AmpersandAmpersandEqualsToken, 77],
          [ts9.SyntaxKind.QuestionQuestionEqualsToken, 78],
          [ts9.SyntaxKind.CaretEqualsToken, 79],
          [ts9.SyntaxKind.Identifier, 80],
          [ts9.SyntaxKind.PrivateIdentifier, 81],
          [ts9.SyntaxKind.BreakKeyword, 83],
          [ts9.SyntaxKind.CaseKeyword, 84],
          [ts9.SyntaxKind.CatchKeyword, 85],
          [ts9.SyntaxKind.ClassKeyword, 86],
          [ts9.SyntaxKind.ConstKeyword, 87],
          [ts9.SyntaxKind.ContinueKeyword, 88],
          [ts9.SyntaxKind.DebuggerKeyword, 89],
          [ts9.SyntaxKind.DefaultKeyword, 90],
          [ts9.SyntaxKind.DeleteKeyword, 91],
          [ts9.SyntaxKind.DoKeyword, 92],
          [ts9.SyntaxKind.ElseKeyword, 93],
          [ts9.SyntaxKind.EnumKeyword, 94],
          [ts9.SyntaxKind.ExportKeyword, 95],
          [ts9.SyntaxKind.ExtendsKeyword, 96],
          [ts9.SyntaxKind.FalseKeyword, 97],
          [ts9.SyntaxKind.FinallyKeyword, 98],
          [ts9.SyntaxKind.ForKeyword, 99],
          [ts9.SyntaxKind.FunctionKeyword, 100],
          [ts9.SyntaxKind.IfKeyword, 101],
          [ts9.SyntaxKind.ImportKeyword, 102],
          [ts9.SyntaxKind.InKeyword, 103],
          [ts9.SyntaxKind.InstanceOfKeyword, 104],
          [ts9.SyntaxKind.NewKeyword, 105],
          [ts9.SyntaxKind.NullKeyword, 106],
          [ts9.SyntaxKind.ReturnKeyword, 107],
          [ts9.SyntaxKind.SuperKeyword, 108],
          [ts9.SyntaxKind.SwitchKeyword, 109],
          [ts9.SyntaxKind.ThisKeyword, 110],
          [ts9.SyntaxKind.ThrowKeyword, 111],
          [ts9.SyntaxKind.TrueKeyword, 112],
          [ts9.SyntaxKind.TryKeyword, 113],
          [ts9.SyntaxKind.TypeOfKeyword, 114],
          [ts9.SyntaxKind.VarKeyword, 115],
          [ts9.SyntaxKind.VoidKeyword, 116],
          [ts9.SyntaxKind.WhileKeyword, 117],
          [ts9.SyntaxKind.WithKeyword, 118],
          [ts9.SyntaxKind.ImplementsKeyword, 119],
          [ts9.SyntaxKind.InterfaceKeyword, 120],
          [ts9.SyntaxKind.LetKeyword, 121],
          [ts9.SyntaxKind.PackageKeyword, 122],
          [ts9.SyntaxKind.PrivateKeyword, 123],
          [ts9.SyntaxKind.ProtectedKeyword, 124],
          [ts9.SyntaxKind.PublicKeyword, 125],
          [ts9.SyntaxKind.StaticKeyword, 126],
          [ts9.SyntaxKind.YieldKeyword, 127],
          [ts9.SyntaxKind.AbstractKeyword, 128],
          [ts9.SyntaxKind.AccessorKeyword, 129],
          [ts9.SyntaxKind.AsKeyword, 130],
          [ts9.SyntaxKind.AssertsKeyword, 131],
          [ts9.SyntaxKind.AssertKeyword, 132],
          [ts9.SyntaxKind.AnyKeyword, 133],
          [ts9.SyntaxKind.AsyncKeyword, 134],
          [ts9.SyntaxKind.AwaitKeyword, 135],
          [ts9.SyntaxKind.BooleanKeyword, 136],
          [ts9.SyntaxKind.ConstructorKeyword, 137],
          [ts9.SyntaxKind.DeclareKeyword, 138],
          [ts9.SyntaxKind.GetKeyword, 139],
          [ts9.SyntaxKind.InferKeyword, 140],
          [ts9.SyntaxKind.IntrinsicKeyword, 141],
          [ts9.SyntaxKind.IsKeyword, 142],
          [ts9.SyntaxKind.KeyOfKeyword, 143],
          [ts9.SyntaxKind.ModuleKeyword, 144],
          [ts9.SyntaxKind.NamespaceKeyword, 145],
          [ts9.SyntaxKind.NeverKeyword, 146],
          [ts9.SyntaxKind.OutKeyword, 147],
          [ts9.SyntaxKind.ReadonlyKeyword, 148],
          [ts9.SyntaxKind.RequireKeyword, 149],
          [ts9.SyntaxKind.NumberKeyword, 150],
          [ts9.SyntaxKind.ObjectKeyword, 151],
          [ts9.SyntaxKind.SatisfiesKeyword, 152],
          [ts9.SyntaxKind.SetKeyword, 153],
          [ts9.SyntaxKind.StringKeyword, 154],
          [ts9.SyntaxKind.SymbolKeyword, 155],
          [ts9.SyntaxKind.TypeKeyword, 156],
          [ts9.SyntaxKind.UndefinedKeyword, 157],
          [ts9.SyntaxKind.UniqueKeyword, 158],
          [ts9.SyntaxKind.UnknownKeyword, 159],
          [ts9.SyntaxKind.UsingKeyword, 160],
          [ts9.SyntaxKind.FromKeyword, 161],
          [ts9.SyntaxKind.GlobalKeyword, 162],
          [ts9.SyntaxKind.BigIntKeyword, 163],
          [ts9.SyntaxKind.OverrideKeyword, 164],
          [ts9.SyntaxKind.OfKeyword, 165],
          [ts9.SyntaxKind.QualifiedName, 166],
          [ts9.SyntaxKind.ComputedPropertyName, 167],
          [ts9.SyntaxKind.TypeParameter, 168],
          [ts9.SyntaxKind.Parameter, 169],
          [ts9.SyntaxKind.Decorator, 170],
          [ts9.SyntaxKind.PropertySignature, 171],
          [ts9.SyntaxKind.PropertyDeclaration, 172],
          [ts9.SyntaxKind.MethodSignature, 173],
          [ts9.SyntaxKind.MethodDeclaration, 174],
          [ts9.SyntaxKind.ClassStaticBlockDeclaration, 175],
          [ts9.SyntaxKind.Constructor, 176],
          [ts9.SyntaxKind.GetAccessor, 177],
          [ts9.SyntaxKind.SetAccessor, 178],
          [ts9.SyntaxKind.CallSignature, 179],
          [ts9.SyntaxKind.ConstructSignature, 180],
          [ts9.SyntaxKind.IndexSignature, 181],
          [ts9.SyntaxKind.TypePredicate, 182],
          [ts9.SyntaxKind.TypeReference, 183],
          [ts9.SyntaxKind.FunctionType, 184],
          [ts9.SyntaxKind.ConstructorType, 185],
          [ts9.SyntaxKind.TypeQuery, 186],
          [ts9.SyntaxKind.TypeLiteral, 187],
          [ts9.SyntaxKind.ArrayType, 188],
          [ts9.SyntaxKind.TupleType, 189],
          [ts9.SyntaxKind.OptionalType, 190],
          [ts9.SyntaxKind.RestType, 191],
          [ts9.SyntaxKind.UnionType, 192],
          [ts9.SyntaxKind.IntersectionType, 193],
          [ts9.SyntaxKind.ConditionalType, 194],
          [ts9.SyntaxKind.InferType, 195],
          [ts9.SyntaxKind.ParenthesizedType, 196],
          [ts9.SyntaxKind.ThisType, 197],
          [ts9.SyntaxKind.TypeOperator, 198],
          [ts9.SyntaxKind.IndexedAccessType, 199],
          [ts9.SyntaxKind.MappedType, 200],
          [ts9.SyntaxKind.LiteralType, 201],
          [ts9.SyntaxKind.NamedTupleMember, 202],
          [ts9.SyntaxKind.TemplateLiteralType, 203],
          [ts9.SyntaxKind.TemplateLiteralTypeSpan, 204],
          [ts9.SyntaxKind.ImportType, 205],
          [ts9.SyntaxKind.ObjectBindingPattern, 206],
          [ts9.SyntaxKind.ArrayBindingPattern, 207],
          [ts9.SyntaxKind.BindingElement, 208],
          [ts9.SyntaxKind.ArrayLiteralExpression, 209],
          [ts9.SyntaxKind.ObjectLiteralExpression, 210],
          [ts9.SyntaxKind.PropertyAccessExpression, 211],
          [ts9.SyntaxKind.ElementAccessExpression, 212],
          [ts9.SyntaxKind.CallExpression, 213],
          [ts9.SyntaxKind.NewExpression, 214],
          [ts9.SyntaxKind.TaggedTemplateExpression, 215],
          [ts9.SyntaxKind.TypeAssertionExpression, 216],
          [ts9.SyntaxKind.ParenthesizedExpression, 217],
          [ts9.SyntaxKind.FunctionExpression, 218],
          [ts9.SyntaxKind.ArrowFunction, 219],
          [ts9.SyntaxKind.DeleteExpression, 220],
          [ts9.SyntaxKind.TypeOfExpression, 221],
          [ts9.SyntaxKind.VoidExpression, 222],
          [ts9.SyntaxKind.AwaitExpression, 223],
          [ts9.SyntaxKind.PrefixUnaryExpression, 224],
          [ts9.SyntaxKind.PostfixUnaryExpression, 225],
          [ts9.SyntaxKind.BinaryExpression, 226],
          [ts9.SyntaxKind.ConditionalExpression, 227],
          [ts9.SyntaxKind.TemplateExpression, 228],
          [ts9.SyntaxKind.YieldExpression, 229],
          [ts9.SyntaxKind.SpreadElement, 230],
          [ts9.SyntaxKind.ClassExpression, 231],
          [ts9.SyntaxKind.OmittedExpression, 232],
          [ts9.SyntaxKind.ExpressionWithTypeArguments, 233],
          [ts9.SyntaxKind.AsExpression, 234],
          [ts9.SyntaxKind.NonNullExpression, 235],
          [ts9.SyntaxKind.MetaProperty, 236],
          [ts9.SyntaxKind.SyntheticExpression, 237],
          [ts9.SyntaxKind.SatisfiesExpression, 238],
          [ts9.SyntaxKind.TemplateSpan, 239],
          [ts9.SyntaxKind.SemicolonClassElement, 240],
          [ts9.SyntaxKind.Block, 241],
          [ts9.SyntaxKind.EmptyStatement, 242],
          [ts9.SyntaxKind.VariableStatement, 243],
          [ts9.SyntaxKind.ExpressionStatement, 244],
          [ts9.SyntaxKind.IfStatement, 245],
          [ts9.SyntaxKind.DoStatement, 246],
          [ts9.SyntaxKind.WhileStatement, 247],
          [ts9.SyntaxKind.ForStatement, 248],
          [ts9.SyntaxKind.ForInStatement, 249],
          [ts9.SyntaxKind.ForOfStatement, 250],
          [ts9.SyntaxKind.ContinueStatement, 251],
          [ts9.SyntaxKind.BreakStatement, 252],
          [ts9.SyntaxKind.ReturnStatement, 253],
          [ts9.SyntaxKind.WithStatement, 254],
          [ts9.SyntaxKind.SwitchStatement, 255],
          [ts9.SyntaxKind.LabeledStatement, 256],
          [ts9.SyntaxKind.ThrowStatement, 257],
          [ts9.SyntaxKind.TryStatement, 258],
          [ts9.SyntaxKind.DebuggerStatement, 259],
          [ts9.SyntaxKind.VariableDeclaration, 260],
          [ts9.SyntaxKind.VariableDeclarationList, 261],
          [ts9.SyntaxKind.FunctionDeclaration, 262],
          [ts9.SyntaxKind.ClassDeclaration, 263],
          [ts9.SyntaxKind.InterfaceDeclaration, 264],
          [ts9.SyntaxKind.TypeAliasDeclaration, 265],
          [ts9.SyntaxKind.EnumDeclaration, 266],
          [ts9.SyntaxKind.ModuleDeclaration, 267],
          [ts9.SyntaxKind.ModuleBlock, 268],
          [ts9.SyntaxKind.CaseBlock, 269],
          [ts9.SyntaxKind.NamespaceExportDeclaration, 270],
          [ts9.SyntaxKind.ImportEqualsDeclaration, 271],
          [ts9.SyntaxKind.ImportDeclaration, 272],
          [ts9.SyntaxKind.ImportClause, 273],
          [ts9.SyntaxKind.NamespaceImport, 274],
          [ts9.SyntaxKind.NamedImports, 275],
          [ts9.SyntaxKind.ImportSpecifier, 276],
          [ts9.SyntaxKind.ExportAssignment, 277],
          [ts9.SyntaxKind.ExportDeclaration, 278],
          [ts9.SyntaxKind.NamedExports, 279],
          [ts9.SyntaxKind.NamespaceExport, 280],
          [ts9.SyntaxKind.ExportSpecifier, 281],
          [ts9.SyntaxKind.MissingDeclaration, 282],
          [ts9.SyntaxKind.ExternalModuleReference, 283],
          [ts9.SyntaxKind.JsxElement, 284],
          [ts9.SyntaxKind.JsxSelfClosingElement, 285],
          [ts9.SyntaxKind.JsxOpeningElement, 286],
          [ts9.SyntaxKind.JsxClosingElement, 287],
          [ts9.SyntaxKind.JsxFragment, 288],
          [ts9.SyntaxKind.JsxOpeningFragment, 289],
          [ts9.SyntaxKind.JsxClosingFragment, 290],
          [ts9.SyntaxKind.JsxAttribute, 291],
          [ts9.SyntaxKind.JsxAttributes, 292],
          [ts9.SyntaxKind.JsxSpreadAttribute, 293],
          [ts9.SyntaxKind.JsxExpression, 294],
          [ts9.SyntaxKind.JsxNamespacedName, 295],
          [ts9.SyntaxKind.CaseClause, 296],
          [ts9.SyntaxKind.DefaultClause, 297],
          [ts9.SyntaxKind.HeritageClause, 298],
          [ts9.SyntaxKind.CatchClause, 299],
          [ts9.SyntaxKind.ImportAttributes, 300],
          [ts9.SyntaxKind.ImportAttribute, 301],
          [ts9.SyntaxKind.PropertyAssignment, 303],
          [ts9.SyntaxKind.ShorthandPropertyAssignment, 304],
          [ts9.SyntaxKind.SpreadAssignment, 305],
          [ts9.SyntaxKind.EnumMember, 306],
          [ts9.SyntaxKind.SourceFile, 307],
          [ts9.SyntaxKind.Bundle, 308],
          [ts9.SyntaxKind.JSDocTypeExpression, 309],
          [ts9.SyntaxKind.JSDocNameReference, 310],
          [ts9.SyntaxKind.JSDocMemberName, 311],
          [ts9.SyntaxKind.JSDocAllType, 312],
          [ts9.SyntaxKind.JSDocUnknownType, 313],
          [ts9.SyntaxKind.JSDocNullableType, 314],
          [ts9.SyntaxKind.JSDocNonNullableType, 315],
          [ts9.SyntaxKind.JSDocOptionalType, 316],
          [ts9.SyntaxKind.JSDocFunctionType, 317],
          [ts9.SyntaxKind.JSDocVariadicType, 318],
          [ts9.SyntaxKind.JSDocNamepathType, 319],
          [ts9.SyntaxKind.JSDoc, 320],
          [ts9.SyntaxKind.JSDocText, 321],
          [ts9.SyntaxKind.JSDocTypeLiteral, 322],
          [ts9.SyntaxKind.JSDocSignature, 323],
          [ts9.SyntaxKind.JSDocLink, 324],
          [ts9.SyntaxKind.JSDocLinkCode, 325],
          [ts9.SyntaxKind.JSDocLinkPlain, 326],
          [ts9.SyntaxKind.JSDocTag, 327],
          [ts9.SyntaxKind.JSDocAugmentsTag, 328],
          [ts9.SyntaxKind.JSDocImplementsTag, 329],
          [ts9.SyntaxKind.JSDocAuthorTag, 330],
          [ts9.SyntaxKind.JSDocDeprecatedTag, 331],
          [ts9.SyntaxKind.JSDocClassTag, 332],
          [ts9.SyntaxKind.JSDocPublicTag, 333],
          [ts9.SyntaxKind.JSDocPrivateTag, 334],
          [ts9.SyntaxKind.JSDocProtectedTag, 335],
          [ts9.SyntaxKind.JSDocReadonlyTag, 336],
          [ts9.SyntaxKind.JSDocOverrideTag, 337],
          [ts9.SyntaxKind.JSDocCallbackTag, 338],
          [ts9.SyntaxKind.JSDocOverloadTag, 339],
          [ts9.SyntaxKind.JSDocEnumTag, 340],
          [ts9.SyntaxKind.JSDocParameterTag, 341],
          [ts9.SyntaxKind.JSDocReturnTag, 342],
          [ts9.SyntaxKind.JSDocThisTag, 343],
          [ts9.SyntaxKind.JSDocTypeTag, 344],
          [ts9.SyntaxKind.JSDocTemplateTag, 345],
          [ts9.SyntaxKind.JSDocTypedefTag, 346],
          [ts9.SyntaxKind.JSDocSeeTag, 347],
          [ts9.SyntaxKind.JSDocPropertyTag, 348],
          [ts9.SyntaxKind.JSDocThrowsTag, 349],
          [ts9.SyntaxKind.JSDocSatisfiesTag, 350],
          [ts9.SyntaxKind.JSDocImportTag, 351],
          [ts9.SyntaxKind.SyntaxList, 352],
          [ts9.SyntaxKind.NotEmittedStatement, 353],
          [ts9.SyntaxKind.PartiallyEmittedExpression, 354],
          [ts9.SyntaxKind.CommaListExpression, 355],
          [ts9.SyntaxKind.SyntheticReferenceExpression, 356],
          [ts9.SyntaxKind.NotEmittedTypeElement, 357]
          // New in 5.8.x. Position in 5.8 is 354 and the rest shifts.
        ]);
        const UnknownStableSyntaxKind = 9999;
        function getPath(node) {
          const path = [];
          while (node !== void 0) {
            path.push(KindMap.get(node.kind) ?? UnknownStableSyntaxKind);
            node = node.parent;
          }
          return path;
        }
        StableSyntaxKinds2.getPath = getPath;
      })(StableSyntaxKinds = tss7.StableSyntaxKinds || (tss7.StableSyntaxKinds = {}));
    })(tss6 || (tss6 = {}));
    module2.exports = tss6;
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/code.ts
var import_typescripts, ts, Nodes, AbstractEmitter, TypeEmitter, ClassEmitter, InterfaceEmitter, EnumEmitter, TypeLiteralEmitter, FunctionEmitter, ModuleEmitter, CodeSnippetBuilder;
var init_code = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/code.ts"() {
    "use strict";
    init_typescript();
    init_protocol();
    init_types();
    import_typescripts = __toESM(require_typescripts());
    ts = typescript_default();
    ((Nodes2) => {
      function getLines(node, includeJSDocComment, sourceFile) {
        sourceFile ??= node.getSourceFile();
        const textStartPosition = node.getStart(sourceFile, includeJSDocComment);
        const startRange = sourceFile.getLineAndCharacterOfPosition(textStartPosition);
        const text = sourceFile.text.substring(textStartPosition, node.getEnd());
        const lines = text.split(/\r?\n/g);
        if (startRange.character > 0) {
          const lineStartPosition = sourceFile.getPositionOfLineAndCharacter(startRange.line, 0);
          const indent = sourceFile.text.substring(lineStartPosition, textStartPosition);
          stripIndent(lines, indent);
        }
        trimLines(lines);
        return lines;
      }
      Nodes2.getLines = getLines;
      function getDocumentation(node) {
        const fullText = node.getFullText();
        const ranges = ts.getLeadingCommentRanges(fullText, 0);
        if (ranges !== void 0 && ranges.length > 0) {
          const start = ranges.at(-1).pos;
          const end = ranges.at(-1).end;
          const text = fullText.substring(start, end).trim();
          const lines = text.split(/\r?\n/);
          trimLines(lines);
          if (lines.length > 1) {
            const line = lines[1];
            const match = line.match(/^\s+/);
            if (match !== null) {
              stripIndent(lines, match[0]);
            }
          }
          return lines;
        }
        return void 0;
      }
      Nodes2.getDocumentation = getDocumentation;
      function stripIndent(lines, indent, start = 1) {
        let allHaveIndent = true;
        for (let index = start; index < lines.length; index++) {
          if (!lines[index].startsWith(indent)) {
            allHaveIndent = false;
            break;
          }
        }
        if (allHaveIndent) {
          for (let index = start; index < lines.length; index++) {
            lines[index] = lines[index].substring(indent.length);
          }
        }
      }
      function trimLines(lines) {
        while (lines.length > 0 && lines[0].trim() === "") {
          lines.shift();
        }
        while (lines.length > 0 && lines.at(-1).trim() === "") {
          lines.pop();
        }
      }
    })(Nodes || (Nodes = {}));
    AbstractEmitter = class {
      context;
      indent;
      lines;
      source;
      additionalSources;
      constructor(context, source, indent = 0) {
        this.context = context;
        this.indent = indent;
        this.source = source.fileName;
        this.lines = [];
        this.additionalSources = /* @__PURE__ */ new Set();
      }
      makeKey(symbols) {
        if (Array.isArray(symbols)) {
          if (symbols.length === 0) {
            return void 0;
          }
          let keys = [];
          for (const symbol of symbols) {
            const key = import_typescripts.Symbols.createVersionedKey(symbol, this.context.session);
            if (key !== void 0) {
              keys.push(key);
            } else {
              keys = void 0;
              break;
            }
          }
          return keys === void 0 ? void 0 : keys.join(";");
        } else {
          return import_typescripts.Symbols.createVersionedKey(symbols, this.context.session);
        }
      }
      getLines() {
        return this.lines;
      }
      getAdditionalSources() {
        this.additionalSources.delete(this.source);
        return this.additionalSources;
      }
      increaseIndent() {
        this.indent++;
      }
      decreaseIndent() {
        this.indent--;
      }
      addLine(line) {
        if (this.indent === 0) {
          this.lines.push(line);
        } else {
          this.lines.push("	".repeat(this.indent) + line);
        }
      }
      addLines(lines) {
        for (const line of lines) {
          this.addLine(line);
        }
      }
      addConstructorDeclaration(declaration) {
        this.addDocumentation(declaration);
        const elements = [];
        if (declaration.modifiers !== void 0) {
          elements.push(declaration.modifiers.map((m) => m.getText()).join(" "));
          elements.push(" ");
        }
        elements.push("constructor");
        elements.push("(");
        elements.push(this.getParameters(declaration.parameters));
        elements.push(");");
        this.addLine(elements.join(""));
      }
      addPropertyDeclaration(declaration) {
        this.addLines(Nodes.getLines(declaration, this.context.includeDocumentation));
      }
      addMethodDeclaration(declaration) {
        this.addDocumentation(declaration);
        const elements = [];
        if (declaration.modifiers !== void 0) {
          elements.push(declaration.modifiers.map((m) => m.getText()).join(" "));
          elements.push(" ");
        }
        elements.push(declaration.name.getText());
        if (declaration.typeParameters !== void 0) {
          elements.push("<");
          elements.push(declaration.typeParameters.map((p) => p.getText()).join(", "));
          elements.push(">");
        }
        elements.push("(");
        if (declaration.parameters !== void 0) {
          elements.push(declaration.parameters.map((p) => p.getText()).join(", "));
        }
        elements.push(")");
        if (declaration.type !== void 0) {
          elements.push(": ");
          elements.push(declaration.type.getText());
        }
        elements.push(";");
        this.addLine(elements.join(""));
      }
      addCallSignatureDeclaration(declaration) {
        this.addDocumentation(declaration);
        const elements = [];
        if (declaration.typeParameters !== void 0) {
          elements.push("<");
          elements.push(declaration.typeParameters.map((p) => p.getText()).join(", "));
          elements.push(">");
        }
        elements.push("(");
        if (declaration.parameters !== void 0) {
          elements.push(declaration.parameters.map((p) => p.getText()).join(", "));
        }
        elements.push(")");
        if (declaration.type !== void 0) {
          elements.push(": ");
          elements.push(declaration.type.getText());
        }
        elements.push(";");
        this.addLine(elements.join(""));
      }
      addGetAccessorDeclaration(declaration) {
        this.addAccessorDeclaration(declaration, "get");
      }
      addSetAccessorDeclaration(declaration) {
        this.addAccessorDeclaration(declaration, "set");
      }
      addAccessorDeclaration(declaration, prefix) {
        this.addDocumentation(declaration);
        const elements = [];
        if (declaration.modifiers !== void 0) {
          elements.push(declaration.modifiers.map((m) => m.getText()).join(" "));
          elements.push(" ");
        }
        elements.push(`${prefix} `);
        elements.push(declaration.name.getText());
        if (declaration.type !== void 0) {
          elements.push(": ");
          elements.push(declaration.type.getText());
        }
        elements.push(";");
        this.addLine(elements.join(""));
      }
      addFunctionDeclaration(declaration, name, ensureModifier) {
        name ??= declaration.name?.getText() ?? "";
        this.addDocumentation(declaration);
        const elements = [];
        elements.push(this.getModifiers(declaration.modifiers, ensureModifier));
        elements.push(" function ");
        elements.push(name);
        elements.push(this.getTypeParameters(declaration.typeParameters));
        elements.push("(");
        elements.push(this.getParameters(declaration.parameters));
        elements.push(")");
        elements.push(this.getReturnTypes(declaration));
        elements.push(";");
        this.addLine(elements.join(""));
      }
      addDocumentation(declaration) {
        if (!this.context.includeDocumentation) {
          return;
        }
        const documentation = Nodes.getDocumentation(declaration);
        if (documentation !== void 0) {
          this.addLines(documentation);
        }
      }
      getModifiers(modifiers, prefix) {
        if (modifiers === void 0) {
          return "";
        }
        const result = [];
        if (prefix !== void 0) {
          result.push(prefix);
        }
        for (const modifier of modifiers) {
          if (modifier.kind === ts.SyntaxKind.AsyncKeyword || modifier.kind === ts.SyntaxKind.DeclareKeyword || modifier.kind === ts.SyntaxKind.ExportKeyword) {
            continue;
          }
          result.push(modifier.getText());
        }
        return result.join(" ");
      }
      getTypeParameters(typeParameters) {
        if (typeParameters === void 0) {
          return "";
        }
        const result = [];
        result.push("<");
        result.push(typeParameters.map((p) => p.getText()).join(", "));
        result.push(">");
        return result.join("");
      }
      getParameters(parameters) {
        if (parameters === void 0) {
          return "";
        }
        return parameters.map((p) => p.getText()).join(", ");
      }
      getReturnTypes(declaration) {
        if (declaration.type === void 0) {
          return "";
        }
        return `: ${declaration.type.getText()}`;
      }
    };
    TypeEmitter = class extends AbstractEmitter {
      type;
      name;
      seen;
      constructor(context, source, type, name) {
        super(context, source);
        this.type = type;
        this.name = name;
        this.seen = /* @__PURE__ */ new Set();
      }
      processMembers(members) {
        for (const [_name, member] of members) {
          if (!this.seen.has(_name)) {
            this.seen.add(_name);
            this.processMember(member);
          }
        }
      }
      processMember(member) {
        const declarations = member.declarations;
        if (declarations === void 0) {
          return;
        }
        if (import_typescripts.Symbols.isProperty(member)) {
          const declaration = declarations[0];
          if (ts.isPropertyDeclaration(declaration) || ts.isPropertySignature(declaration)) {
            this.addPropertyDeclaration(declaration);
          }
        } else if (import_typescripts.Symbols.isMethod(member)) {
          for (const declaration of declarations) {
            if (ts.isMethodDeclaration(declaration) || ts.isMethodSignature(declaration)) {
              this.addMethodDeclaration(declaration);
            }
          }
        } else if (import_typescripts.Symbols.isSetAccessor(member) || import_typescripts.Symbols.isGetAccessor(member)) {
          for (const declaration of declarations) {
            if (ts.isGetAccessorDeclaration(declaration)) {
              this.addGetAccessorDeclaration(declaration);
            } else if (ts.isSetAccessorDeclaration(declaration)) {
              this.addSetAccessorDeclaration(declaration);
            }
          }
        } else if (import_typescripts.Symbols.isSignature(member)) {
          for (const declaration of declarations) {
            if (ts.isCallSignatureDeclaration(declaration)) {
              this.addCallSignatureDeclaration(declaration);
            }
          }
        } else if (import_typescripts.Symbols.isConstructor(member)) {
          for (const declaration of declarations) {
            if (ts.isConstructorDeclaration(declaration)) {
              this.addConstructorDeclaration(declaration);
            }
          }
        }
      }
      getTypeParameters() {
        const declarations = this.type.declarations;
        if (declarations === void 0 || declarations.length === 0) {
          return "";
        }
        const declaration = declarations[0];
        if (ts.isClassDeclaration(declaration) || ts.isInterfaceDeclaration(declaration) || ts.isTypeAliasDeclaration(declaration)) {
          if (declaration.typeParameters !== void 0) {
            return super.getTypeParameters(declaration.typeParameters);
          }
        }
        return "";
      }
    };
    ClassEmitter = class extends TypeEmitter {
      superClasses;
      includePrivates;
      key;
      constructor(context, symbols, source, clazz, name, includeSuperClasses, includePrivates) {
        super(context, source, clazz, name);
        this.includePrivates = includePrivates;
        this.key = void 0;
        if (includeSuperClasses) {
          this.superClasses = new Array(...symbols.getAllSuperClasses(clazz));
          this.key = this.makeKey([clazz, ...this.superClasses]);
        } else {
          this.key = this.makeKey(clazz);
          this.superClasses = void 0;
        }
      }
      emit() {
        this.addLine(`declare class ${this.name}${this.getTypeParameters()} {`);
        this.increaseIndent();
        if (this.type.members !== void 0) {
          import_typescripts.Symbols.fillSources(this.additionalSources, this.type);
          this.processMembers(this.type.members);
        }
        if (this.superClasses !== void 0) {
          for (let i = this.superClasses.length - 1; i >= 0; i--) {
            const superClass = this.superClasses[i];
            if (superClass.members !== void 0) {
              import_typescripts.Symbols.fillSources(this.additionalSources, superClass);
              this.processMembers(superClass.members);
            }
          }
        }
        this.decreaseIndent();
        this.addLine("}");
      }
      processMember(member) {
        if (!this.includePrivates && import_typescripts.Symbols.isPrivate(member)) {
          return;
        }
        super.processMember(member);
      }
    };
    InterfaceEmitter = class extends TypeEmitter {
      superTypes;
      key;
      constructor(context, symbols, source, type, name) {
        super(context, source, type, name);
        this.superTypes = new Array(...symbols.getAllSuperTypes(type)).filter((t) => import_typescripts.Symbols.isInterface(t));
        if (this.superTypes.length === 0) {
          this.key = this.makeKey(type);
        } else {
          this.key = this.makeKey([type, ...this.superTypes]);
        }
      }
      emit() {
        this.addLine(`interface ${this.name}${this.getTypeParameters()} {`);
        this.increaseIndent();
        if (this.type.members !== void 0) {
          import_typescripts.Symbols.fillSources(this.additionalSources, this.type);
          this.processMembers(this.type.members);
        }
        for (let i = this.superTypes.length - 1; i >= 0; i--) {
          const superType = this.superTypes[i];
          if (superType.members !== void 0) {
            import_typescripts.Symbols.fillSources(this.additionalSources, superType);
            this.processMembers(superType.members);
          }
        }
        this.decreaseIndent();
        this.addLine("}");
      }
    };
    EnumEmitter = class extends AbstractEmitter {
      type;
      name;
      key;
      constructor(context, source, type, name) {
        super(context, source);
        this.type = type;
        this.name = name;
        this.key = this.makeKey(type);
      }
      emit() {
        this.addLine(`${import_typescripts.Symbols.isConstEnum(this.type) ? "const " : ""}enum ${this.name} {`);
        this.increaseIndent();
        if (this.type.exports !== void 0) {
          let index = 0;
          const last = this.type.exports.size - 1;
          for (const [_name, member] of this.type.exports) {
            const declarations = member.declarations;
            if (declarations === void 0) {
              continue;
            }
            const declaration = declarations[0];
            if (ts.isEnumMember(declaration)) {
              const lines = Nodes.getLines(declaration, this.context.includeDocumentation);
              if (index < last) {
                lines[lines.length - 1] += ",";
              }
              this.addLines(lines);
            }
            index++;
          }
        }
        this.decreaseIndent();
        this.addLine("}");
      }
    };
    TypeLiteralEmitter = class extends TypeEmitter {
      key;
      constructor(context, source, type, name) {
        super(context, source, type, name);
      }
      emit() {
        this.addLine(`type ${this.name} = {`);
        this.increaseIndent();
        if (this.type.members !== void 0) {
          this.processMembers(this.type.members);
        }
        this.decreaseIndent();
        this.addLine("}");
      }
    };
    FunctionEmitter = class extends AbstractEmitter {
      func;
      name;
      constructor(context, source, func, name) {
        super(context, source);
        this.func = func;
        this.name = name ?? func.getName();
      }
      get key() {
        return void 0;
      }
      emit(currentSourceFile) {
        const declarations = this.func.declarations;
        if (declarations !== void 0) {
          for (const declaration of declarations) {
            const fileName = declaration.getSourceFile().fileName;
            if (fileName === currentSourceFile.fileName) {
              continue;
            }
            if (ts.isFunctionDeclaration(declaration)) {
              this.addFunctionDeclaration(declaration, this.name, "declare");
              this.additionalSources.add(fileName);
            }
          }
        }
      }
    };
    ModuleEmitter = class extends AbstractEmitter {
      module;
      name;
      constructor(context, source, module2, name) {
        super(context, source);
        this.module = module2;
        this.name = name ?? module2.getName();
      }
      get key() {
        return void 0;
      }
      emit(currentSourceFile) {
        this.addLine(`declare namespace ${this.name} {`);
        this.increaseIndent();
        const exports2 = this.module.exports;
        if (exports2 !== void 0) {
          this.addExports(exports2, currentSourceFile);
        }
        this.decreaseIndent();
        this.addLine("}");
      }
      addExports(members, currentSourceFile) {
        for (const [_name, member] of members) {
          const declarations = member.declarations;
          if (declarations === void 0) {
            continue;
          }
          if (import_typescripts.Symbols.isFunction(member)) {
            for (const declaration of declarations) {
              const fileName = declaration.getSourceFile().fileName;
              if (fileName === currentSourceFile.fileName) {
                continue;
              }
              if (ts.isFunctionDeclaration(declaration)) {
                this.addFunctionDeclaration(declaration, void 0, "declare");
                this.additionalSources.add(fileName);
              }
            }
          }
        }
      }
    };
    CodeSnippetBuilder = class extends ProgramContext {
      lines;
      source;
      additionalSources;
      indent = 0;
      context;
      symbols;
      currentSourceFile;
      constructor(context, symbols, currentSourceFile) {
        super();
        this.lines = [];
        this.source = void 0;
        this.additionalSources = /* @__PURE__ */ new Set();
        this.context = context;
        this.symbols = symbols;
        this.currentSourceFile = currentSourceFile;
      }
      getSymbolInfo(symbol) {
        const result = super.getSymbolInfo(symbol);
        if (result.skip === false && result.primary.fileName === this.currentSourceFile.fileName) {
          return { skip: true };
        }
        return result;
      }
      increaseIndent() {
        this.indent++;
      }
      decreaseIndent() {
        this.indent--;
      }
      getProgram() {
        return this.symbols.getProgram();
      }
      addSource(source) {
        if (this.source === void 0) {
          this.source = source;
        } else {
          this.additionalSources.add(source);
        }
      }
      addAdditionalSource(sources) {
        if (sources === void 0) {
          return;
        }
        for (const source of sources) {
          this.additionalSources.add(source);
        }
      }
      isEmpty() {
        return this.lines.length === 0 || this.source === void 0;
      }
      snippet(key) {
        if (this.source === void 0) {
          throw new RecoverableError("No source", RecoverableError.NoSourceFile);
        }
        this.additionalSources.delete(this.source);
        return CodeSnippet.create(key, this.source, this.additionalSources.size === 0 ? void 0 : [...this.additionalSources], this.lines.join("\n"));
      }
      addDeclaration(declaration) {
        const sourceFile = declaration.getSourceFile();
        if (sourceFile.fileName === this.currentSourceFile.fileName || this.skipDeclaration(declaration, sourceFile)) {
          return;
        }
        this.addLines(Nodes.getLines(declaration, this.context.includeDocumentation, sourceFile));
        this.addSource(sourceFile.fileName);
      }
      addLines(lines) {
        if (lines.length === 0) {
          return;
        }
        if (this.indent === 0) {
          this.lines.push(...lines);
        } else {
          this.lines.push(...lines.map((line) => `${"	".repeat(this.indent)}${line}`));
        }
      }
      addClassSymbol(clazz, name, includeSuperClasses = true, includePrivates = false) {
        if (!import_typescripts.Symbols.isClass(clazz)) {
          return;
        }
        const info = this.getSymbolInfo(clazz);
        if (info.skip) {
          return;
        }
        this.addEmitter(new ClassEmitter(this.context, this.symbols, info.primary, clazz, name, includeSuperClasses, includePrivates));
      }
      addTypeLiteralSymbol(type, name) {
        if (!import_typescripts.Symbols.isTypeLiteral(type)) {
          return;
        }
        const info = this.getSymbolInfo(type);
        if (info.skip) {
          return;
        }
        this.addEmitter(new TypeLiteralEmitter(this.context, info.primary, type, name));
      }
      addInterfaceSymbol(iface, name) {
        if (!import_typescripts.Symbols.isInterface(iface)) {
          return;
        }
        const info = this.getSymbolInfo(iface);
        if (info.skip) {
          return;
        }
        this.addEmitter(new InterfaceEmitter(this.context, this.symbols, info.primary, iface, name));
      }
      addTypeAliasSymbol(symbol, _name) {
        if (!import_typescripts.Symbols.isTypeAlias(symbol)) {
          return;
        }
      }
      addEnumSymbol(enm, name) {
        if (!import_typescripts.Symbols.isEnum(enm)) {
          return;
        }
        const info = this.getSymbolInfo(enm);
        if (info.skip) {
          return;
        }
        this.addEmitter(new EnumEmitter(this.context, info.primary, enm, name));
      }
      addFunctionSymbol(func, name) {
        if (!import_typescripts.Symbols.isFunction(func)) {
          return;
        }
        const info = this.getSymbolInfo(func);
        if (info.skip) {
          return;
        }
        this.addEmitter(new FunctionEmitter(this.context, info.primary, func, name));
      }
      addModuleSymbol(module2, name) {
        if (!import_typescripts.Symbols.isValueModule(module2)) {
          return;
        }
        const info = this.getSymbolInfo(module2);
        if (info.skip) {
          return;
        }
        this.addEmitter(new ModuleEmitter(this.context, info.primary, module2, name));
      }
      addTypeSymbol(type, name) {
        if (name === void 0 && import_typescripts.Symbols.isInternal(type)) {
          return;
        }
        const symbolName = name ?? type.getName();
        if (import_typescripts.Symbols.isClass(type)) {
          this.addClassSymbol(type, symbolName);
        } else if (import_typescripts.Symbols.isInterface(type)) {
          this.addInterfaceSymbol(type, symbolName);
        } else if (import_typescripts.Symbols.isTypeAlias(type)) {
          this.addTypeAliasSymbol(type, symbolName);
        } else if (import_typescripts.Symbols.isEnum(type)) {
          this.addEnumSymbol(type, symbolName);
        } else if (import_typescripts.Symbols.isFunction(type)) {
          this.addFunctionSymbol(type, symbolName);
        } else if (import_typescripts.Symbols.isValueModule(type)) {
          this.addModuleSymbol(type, symbolName);
        } else if (import_typescripts.Symbols.isTypeLiteral(type) && symbolName !== void 0) {
          this.addTypeLiteralSymbol(type, symbolName);
        }
      }
      addEmitter(emitter) {
        let lines;
        let uri;
        let additionalUris;
        const session = this.context.session;
        if (emitter.key !== void 0) {
          const code = session.getCachedCode(emitter.key);
          if (code !== void 0) {
            lines = code.value;
            uri = code.uri;
            additionalUris = code.additionalUris;
          }
        }
        if (lines === void 0 || uri === void 0) {
          emitter.emit(this.currentSourceFile);
          lines = emitter.getLines();
          uri = emitter.source;
          additionalUris = emitter.getAdditionalSources();
          if (emitter.key !== void 0) {
            session.cacheCode(emitter.key, { value: lines, uri, additionalUris });
          }
        }
        if (this.indent === 0) {
          this.lines.push(...lines);
        } else {
          this.lines.push(...lines.map((line) => `${"	".repeat(this.indent)}${line}`));
        }
        this.addSource(uri);
        this.addAdditionalSource(additionalUris);
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/utils.ts
var LinkedMap, Cache, LRUCache;
var init_utils = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/utils.ts"() {
    "use strict";
    LinkedMap = class {
      [Symbol.toStringTag] = "LinkedMap";
      _map;
      _head;
      _tail;
      _size;
      _state;
      constructor() {
        this._map = /* @__PURE__ */ new Map();
        this._head = void 0;
        this._tail = void 0;
        this._size = 0;
        this._state = 0;
      }
      clear() {
        this._map.clear();
        this._head = void 0;
        this._tail = void 0;
        this._size = 0;
        this._state++;
      }
      isEmpty() {
        return !this._head && !this._tail;
      }
      get size() {
        return this._size;
      }
      get first() {
        return this._head?.value;
      }
      get last() {
        return this._tail?.value;
      }
      has(key) {
        return this._map.has(key);
      }
      get(key, touch = 0 /* None */) {
        const item = this._map.get(key);
        if (!item) {
          return void 0;
        }
        if (touch !== 0 /* None */) {
          this.touch(item, touch);
        }
        return item.value;
      }
      set(key, value, touch = 0 /* None */) {
        let item = this._map.get(key);
        if (item) {
          item.value = value;
          if (touch !== 0 /* None */) {
            this.touch(item, touch);
          }
        } else {
          item = { key, value, next: void 0, previous: void 0 };
          switch (touch) {
            case 0 /* None */:
              this.addItemLast(item);
              break;
            case 1 /* AsOld */:
              this.addItemFirst(item);
              break;
            case 2 /* AsNew */:
              this.addItemLast(item);
              break;
            default:
              this.addItemLast(item);
              break;
          }
          this._map.set(key, item);
          this._size++;
        }
        return this;
      }
      delete(key) {
        return !!this.remove(key);
      }
      remove(key) {
        const item = this._map.get(key);
        if (!item) {
          return void 0;
        }
        this._map.delete(key);
        this.removeItem(item);
        this._size--;
        return item.value;
      }
      shift() {
        if (!this._head && !this._tail) {
          return void 0;
        }
        if (!this._head || !this._tail) {
          throw new Error("Invalid list");
        }
        const item = this._head;
        this._map.delete(item.key);
        this.removeItem(item);
        this._size--;
        return item.value;
      }
      forEach(callbackfn, thisArg) {
        const state = this._state;
        let current = this._head;
        while (current) {
          if (thisArg) {
            callbackfn.bind(thisArg)(current.value, current.key, this);
          } else {
            callbackfn(current.value, current.key, this);
          }
          if (this._state !== state) {
            throw new Error(`LinkedMap got modified during iteration.`);
          }
          current = current.next;
        }
      }
      keys() {
        const map = this;
        const state = this._state;
        let current = this._head;
        const iterator = {
          [Symbol.iterator]() {
            return iterator;
          },
          next() {
            if (map._state !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: current.key, done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      values() {
        const map = this;
        const state = this._state;
        let current = this._head;
        const iterator = {
          [Symbol.iterator]() {
            return iterator;
          },
          next() {
            if (map._state !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: current.value, done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      entries() {
        const map = this;
        const state = this._state;
        let current = this._head;
        const iterator = {
          [Symbol.iterator]() {
            return iterator;
          },
          next() {
            if (map._state !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: [current.key, current.value], done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      [Symbol.iterator]() {
        return this.entries();
      }
      trimOld(newSize) {
        if (newSize >= this.size) {
          return;
        }
        if (newSize === 0) {
          this.clear();
          return;
        }
        let current = this._head;
        let currentSize = this.size;
        while (current && currentSize > newSize) {
          this._map.delete(current.key);
          current = current.next;
          currentSize--;
        }
        this._head = current;
        this._size = currentSize;
        if (current) {
          current.previous = void 0;
        }
        this._state++;
      }
      trimNew(newSize) {
        if (newSize >= this.size) {
          return;
        }
        if (newSize === 0) {
          this.clear();
          return;
        }
        let current = this._tail;
        let currentSize = this.size;
        while (current && currentSize > newSize) {
          this._map.delete(current.key);
          current = current.previous;
          currentSize--;
        }
        this._tail = current;
        this._size = currentSize;
        if (current) {
          current.next = void 0;
        }
        this._state++;
      }
      addItemFirst(item) {
        if (!this._head && !this._tail) {
          this._tail = item;
        } else if (!this._head) {
          throw new Error("Invalid list");
        } else {
          item.next = this._head;
          this._head.previous = item;
        }
        this._head = item;
        this._state++;
      }
      addItemLast(item) {
        if (!this._head && !this._tail) {
          this._head = item;
        } else if (!this._tail) {
          throw new Error("Invalid list");
        } else {
          item.previous = this._tail;
          this._tail.next = item;
        }
        this._tail = item;
        this._state++;
      }
      removeItem(item) {
        if (item === this._head && item === this._tail) {
          this._head = void 0;
          this._tail = void 0;
        } else if (item === this._head) {
          if (!item.next) {
            throw new Error("Invalid list");
          }
          item.next.previous = void 0;
          this._head = item.next;
        } else if (item === this._tail) {
          if (!item.previous) {
            throw new Error("Invalid list");
          }
          item.previous.next = void 0;
          this._tail = item.previous;
        } else {
          const next = item.next;
          const previous = item.previous;
          if (!next || !previous) {
            throw new Error("Invalid list");
          }
          next.previous = previous;
          previous.next = next;
        }
        item.next = void 0;
        item.previous = void 0;
        this._state++;
      }
      touch(item, touch) {
        if (!this._head || !this._tail) {
          throw new Error("Invalid list");
        }
        if (touch !== 1 /* AsOld */ && touch !== 2 /* AsNew */) {
          return;
        }
        if (touch === 1 /* AsOld */) {
          if (item === this._head) {
            return;
          }
          const next = item.next;
          const previous = item.previous;
          if (item === this._tail) {
            previous.next = void 0;
            this._tail = previous;
          } else {
            next.previous = previous;
            previous.next = next;
          }
          item.previous = void 0;
          item.next = this._head;
          this._head.previous = item;
          this._head = item;
          this._state++;
        } else if (touch === 2 /* AsNew */) {
          if (item === this._tail) {
            return;
          }
          const next = item.next;
          const previous = item.previous;
          if (item === this._head) {
            next.previous = void 0;
            this._head = next;
          } else {
            next.previous = previous;
            previous.next = next;
          }
          item.next = void 0;
          item.previous = this._tail;
          this._tail.next = item;
          this._tail = item;
          this._state++;
        }
      }
      toJSON() {
        const data = [];
        this.forEach((value, key) => {
          data.push([key, value]);
        });
        return data;
      }
      fromJSON(data) {
        this.clear();
        for (const [key, value] of data) {
          this.set(key, value);
        }
      }
    };
    Cache = class extends LinkedMap {
      _limit;
      _ratio;
      constructor(limit, ratio = 1) {
        super();
        this._limit = limit;
        this._ratio = Math.min(Math.max(0, ratio), 1);
      }
      get limit() {
        return this._limit;
      }
      set limit(limit) {
        this._limit = limit;
        this.checkTrim();
      }
      get ratio() {
        return this._ratio;
      }
      set ratio(ratio) {
        this._ratio = Math.min(Math.max(0, ratio), 1);
        this.checkTrim();
      }
      get(key, touch = 2 /* AsNew */) {
        return super.get(key, touch);
      }
      peek(key) {
        return super.get(key, 0 /* None */);
      }
      set(key, value) {
        super.set(key, value, 2 /* AsNew */);
        return this;
      }
      checkTrim() {
        if (this.size > this._limit) {
          this.trim(Math.round(this._limit * this._ratio));
        }
      }
    };
    LRUCache = class extends Cache {
      constructor(limit, ratio = 1) {
        super(limit, ratio);
      }
      trim(newSize) {
        this.trimOld(newSize);
      }
      set(key, value) {
        super.set(key, value);
        this.checkTrim();
        return this;
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/contextProvider.ts
var import_typescripts2, ts2, RequestContext, Search, NullLogger, ComputeContextSession, LanguageServerSession, RunnableResult, RunnableResultReference, ContextResult, CacheScopes, CacheBasedContextRunnable, AbstractContextRunnable, ContextRunnableCollector, ContextProvider, TokenBudgetExhaustedError, CharacterBudget;
var init_contextProvider = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/contextProvider.ts"() {
    "use strict";
    init_typescript();
    init_code();
    init_protocol();
    init_types();
    import_typescripts2 = __toESM(require_typescripts());
    init_utils();
    ts2 = typescript_default();
    RequestContext = class {
      symbols;
      neighborFiles;
      clientSideRunnableResults;
      clientSideContextItems;
      session;
      includeDocumentation;
      constructor(session, neighborFiles, clientSideRunnableResults, includeDocumentation) {
        this.session = session;
        this.symbols = /* @__PURE__ */ new Map();
        this.neighborFiles = neighborFiles;
        this.clientSideRunnableResults = clientSideRunnableResults;
        this.clientSideContextItems = /* @__PURE__ */ new Map();
        for (const rr of clientSideRunnableResults.values()) {
          for (const item of rr.items) {
            this.clientSideContextItems.set(item.key, item);
          }
        }
        this.includeDocumentation = includeDocumentation;
      }
      getSymbols(program) {
        let result = this.symbols.get(program);
        if (result === void 0) {
          result = new import_typescripts2.Symbols(program);
          this.symbols.set(program, result);
        }
        return result;
      }
      getPreferredNeighborFiles(program) {
        const result = [];
        for (const file of this.neighborFiles) {
          const sourceFile = program.getSourceFile(file);
          if (sourceFile !== void 0) {
            result.push(sourceFile);
          }
        }
        return result;
      }
      createContextItemReferenceIfManaged(key) {
        const cachedItem = this.clientSideContextItems.get(key);
        return cachedItem !== void 0 ? ContextItemReference.create(cachedItem.key) : void 0;
      }
      clientHasContextItem(key) {
        return this.clientSideContextItems.has(key);
      }
    };
    Search = class extends ProgramContext {
      program;
      symbols;
      constructor(program, symbols = new import_typescripts2.Symbols(program)) {
        super();
        if (program !== symbols.getProgram()) {
          throw new Error("Program and symbols program must match");
        }
        this.program = program;
        this.symbols = symbols;
      }
      getSymbols() {
        return this.symbols;
      }
      getProgram() {
        return this.program;
      }
      getHeritageSymbol(node) {
        let result = this.symbols.getLeafSymbolAtLocation(node);
        if (result === void 0) {
          return void 0;
        }
        if (import_typescripts2.Symbols.isAlias(result)) {
          result = this.symbols.getLeafSymbol(result);
        }
        let counter = 0;
        while (import_typescripts2.Symbols.isTypeAlias(result) && counter < 10) {
          const declarations = result.declarations;
          if (declarations !== void 0) {
            const start = result;
            for (const declaration of declarations) {
              if (ts2.isTypeAliasDeclaration(declaration)) {
                const type = declaration.type;
                if (ts2.isTypeReferenceNode(type)) {
                  result = this.symbols.getLeafSymbolAtLocation(type.typeName);
                }
              }
            }
            if (start === result) {
              break;
            }
          }
          counter++;
        }
        return result;
      }
      static getNodeInProgram(program, node) {
        function sameChain(node2, other2) {
          if (node2 === void 0 || other2 === void 0) {
            return node2 === other2;
          }
          while (node2 !== void 0 && other2 !== void 0) {
            if (node2.kind !== other2.kind || node2.pos !== other2.pos || node2.end !== other2.end) {
              return false;
            }
            node2 = node2.parent;
            other2 = other2.parent;
          }
          return node2 === void 0 && other2 === void 0;
        }
        const fileName = node.getSourceFile().fileName;
        const other = program.getSourceFile(fileName);
        if (other === void 0) {
          throw new RecoverableError(`No source file found for ${fileName}`, RecoverableError.SourceFileNotFound);
        }
        const candidate = import_typescripts2.default.getTokenAtPosition(other, node.pos);
        let otherNode = candidate;
        if (otherNode === void 0) {
          throw new RecoverableError(`No node found for ${fileName}:${node.pos}`, RecoverableError.NodeNotFound);
        }
        while (otherNode !== void 0) {
          if (node.pos === otherNode.pos && node.end === otherNode.end && node.kind === otherNode.kind && sameChain(node.parent, otherNode.parent)) {
            return otherNode;
          }
          otherNode = otherNode.parent;
        }
        throw new RecoverableError(`Found node ${candidate.kind} for node ${node.kind} in file ${fileName}:${node.pos}`, RecoverableError.NodeKindMismatch);
      }
    };
    NullLogger = class {
      info() {
      }
      msg() {
      }
      startGroup() {
      }
      endGroup() {
      }
    };
    ComputeContextSession = class {
      host;
      codeCache;
      importedByState;
      supportsCaching;
      constructor(host, supportsCaching) {
        this.host = host;
        this.codeCache = new LRUCache(100);
        this.importedByState = /* @__PURE__ */ new Map();
        this.supportsCaching = supportsCaching;
      }
      getImportedByState(key) {
        let state = this.importedByState.get(key);
        if (state === void 0) {
          state = new import_typescripts2.ImportedByState(key);
          this.importedByState.set(key, state);
        }
        return state;
      }
      run(search, context, token) {
        const programsToSearch = this.getPossiblePrograms(search, context);
        for (const program of programsToSearch) {
          const programSearch = search.with(program);
          const result = programSearch.run(context, token);
          if (result !== void 0) {
            return [program, result];
          }
        }
        return [void 0, void 0];
      }
      getPossiblePrograms(search, context) {
        const candidates = [];
        for (const languageService of this.getLanguageServices()) {
          const program = languageService.getProgram();
          if (program === void 0) {
            continue;
          }
          const score = search.score(program, context);
          if (score > 0) {
            candidates.push([score, program]);
          }
        }
        return candidates.sort((a, b) => b[0] - a[0]).map((c) => c[1]);
      }
      getCachedCode(symbolOrKey, symbol) {
        if (!this.supportsCaching) {
          return void 0;
        }
        if (typeof symbolOrKey === "string") {
          return this.codeCache.get(symbolOrKey);
        } else {
          const key = import_typescripts2.Symbols.createVersionedKey(symbol, this);
          return key === void 0 ? void 0 : this.codeCache.get(key);
        }
      }
      cacheCode(symbolOrKey, code) {
        if (!this.supportsCaching) {
          return;
        }
        if (typeof symbolOrKey === "string") {
          this.codeCache.set(symbolOrKey, code);
        } else {
          const key = import_typescripts2.Symbols.createVersionedKey(symbolOrKey, this);
          if (key !== void 0) {
            this.codeCache.set(key, code);
          }
        }
      }
      enableBlueprintSearch() {
        return false;
      }
    };
    LanguageServerSession = class extends ComputeContextSession {
      session;
      logger;
      constructor(session, host) {
        super(host, true);
        this.session = session;
        const projectService = import_typescripts2.Sessions.getProjectService(this.session);
        this.logger = projectService?.logger ?? new NullLogger();
      }
      logError(error, cmd) {
        this.session.logError(error, cmd);
      }
      getFileAndProject(args) {
        return import_typescripts2.Sessions.getFileAndProject(this.session, args);
      }
      getPositionInFile(args, file) {
        return import_typescripts2.Sessions.getPositionInFile(this.session, args, file);
      }
      *getLanguageServices(sourceFile) {
        const projectService = import_typescripts2.Sessions.getProjectService(this.session);
        if (projectService === void 0) {
          return;
        }
        if (sourceFile === void 0) {
          for (const project of projectService.configuredProjects.values()) {
            const languageService = project.getLanguageService();
            yield languageService;
          }
          for (const project of projectService.inferredProjects) {
            const languageService = project.getLanguageService();
            yield languageService;
          }
          for (const project of projectService.externalProjects) {
            const languageService = project.getLanguageService();
            yield languageService;
          }
        } else {
          const file = ts2.server.toNormalizedPath(sourceFile.fileName);
          const scriptInfo = projectService.getScriptInfoForNormalizedPath(file);
          yield* scriptInfo ? scriptInfo.containingProjects.map((p) => p.getLanguageService()) : [];
        }
      }
      getScriptVersion(sourceFile) {
        const file = ts2.server.toNormalizedPath(sourceFile.fileName);
        const projectService = import_typescripts2.Sessions.getProjectService(this.session);
        if (projectService === void 0) {
          return void 0;
        }
        const scriptInfo = projectService.getScriptInfoForNormalizedPath(file);
        return scriptInfo?.getLatestVersion();
      }
    };
    RunnableResult = class {
      id;
      runnableResultContext;
      primaryBudget;
      secondaryBudget;
      state;
      speculativeKind;
      cache;
      priority;
      items;
      constructor(id, priority, runnableResultContext, primaryBudget, secondaryBudget, speculativeKind, cache) {
        this.id = id;
        this.priority = priority;
        this.runnableResultContext = runnableResultContext;
        this.primaryBudget = primaryBudget;
        this.secondaryBudget = secondaryBudget;
        this.state = "created" /* Created */;
        this.speculativeKind = speculativeKind;
        this.cache = cache;
        this.items = [];
      }
      isPrimaryBudgetExhausted() {
        if (this.primaryBudget.isExhausted()) {
          this.state = "isFull" /* IsFull */;
          return true;
        }
        return false;
      }
      isSecondaryBudgetExhausted() {
        return this.secondaryBudget.isExhausted();
      }
      done() {
        if (this.state === "created" /* Created */ || this.state === "inProgress" /* InProgress */) {
          this.state = "finished" /* Finished */;
        }
      }
      setCacheInfo(cache) {
        this.cache = cache;
      }
      addFromKnownItems(key) {
        this.state = "inProgress" /* InProgress */;
        const reference = this.runnableResultContext.createContextItemReference(key);
        if (reference === void 0) {
          return false;
        }
        this.items.push(reference);
        return true;
      }
      addTrait(traitKind, name, value) {
        this.state = "inProgress" /* InProgress */;
        const trait = Trait.create(traitKind, name, value);
        this.items.push(this.runnableResultContext.manageContextItem(trait));
        this.primaryBudget.spent(Trait.sizeInChars(trait));
      }
      addSnippet(code, location, key, ifRoom = false) {
        const budget = location === 0 /* Primary */ ? this.primaryBudget : this.secondaryBudget;
        if (code.isEmpty()) {
          return true;
        }
        const snippet = code.snippet(key);
        const size = CodeSnippet.sizeInChars(snippet);
        if (ifRoom && !budget.hasRoom(size)) {
          this.state = "isFull" /* IsFull */;
          return false;
        }
        this.state = "inProgress" /* InProgress */;
        budget.spent(size);
        this.items.push(this.runnableResultContext.manageContextItem(snippet));
        return true;
      }
      toJson() {
        return {
          kind: "computedResult" /* ComputedResult */,
          id: this.id,
          state: this.state,
          priority: this.priority,
          items: this.items,
          cache: this.cache,
          speculativeKind: this.speculativeKind
        };
      }
    };
    RunnableResultReference = class {
      cached;
      constructor(cached) {
        this.cached = cached;
      }
      get items() {
        const result = [];
        for (const item of this.cached.items) {
          result.push(ContextItemReference.create(item.key));
        }
        return result;
      }
      toJson() {
        return {
          kind: "reference" /* Reference */,
          id: this.cached.id
        };
      }
    };
    ContextResult = class {
      primaryBudget;
      secondaryBudget;
      context;
      state;
      path;
      timings;
      timedOut;
      errors;
      runnableResults = [];
      contextItems;
      constructor(primaryBudget, secondaryBudget, context) {
        this.primaryBudget = primaryBudget;
        this.secondaryBudget = secondaryBudget;
        this.context = context;
        this.state = "created" /* Created */;
        this.path = void 0;
        this.timedOut = false;
        this.errors = [];
        this.runnableResults = [];
        this.contextItems = /* @__PURE__ */ new Map();
      }
      getSession() {
        return this.context.session;
      }
      addPath(path) {
        this.path = path;
      }
      addErrorData(error) {
        this.errors.push(ErrorData.create(error.code, error.message));
      }
      addTimings(totalTime, computeTime) {
        this.timings = Timings.create(totalTime, computeTime);
      }
      setTimedOut(timedOut) {
        this.timedOut = timedOut;
      }
      createRunnableResult(id, priority, speculativeKind, cache) {
        this.state = "inProgress" /* InProgress */;
        const result = new RunnableResult(id, priority, this, this.primaryBudget, this.secondaryBudget, speculativeKind, cache);
        this.runnableResults.push(result);
        return result;
      }
      addRunnableResultReference(cached) {
        this.state = "inProgress" /* InProgress */;
        this.runnableResults.push(new RunnableResultReference(cached));
      }
      createContextItemReference(key) {
        const clientSide = this.context.createContextItemReferenceIfManaged(key);
        if (clientSide !== void 0) {
          return clientSide;
        }
        const serverSide = this.contextItems.get(key);
        if (serverSide !== void 0) {
          return ContextItemReference.create(key);
        }
        return void 0;
      }
      manageContextItem(item) {
        if (!ContextItem.hasKey(item)) {
          return item;
        }
        const key = item.key;
        if (this.context.clientHasContextItem(key)) {
          return ContextItemReference.create(key);
        }
        if (this.contextItems.has(key)) {
          return ContextItemReference.create(key);
        }
        this.contextItems.set(key, item);
        return ContextItemReference.create(key);
      }
      done() {
        this.state = "finished" /* Finished */;
      }
      items() {
        const seen = /* @__PURE__ */ new Set();
        const items = [];
        const runnableResults = this.runnableResults.slice().filter((item) => item instanceof RunnableResult).sort((a, b) => {
          return a.priority < b.priority ? 1 : a.priority > b.priority ? -1 : 0;
        });
        for (const runnableResult of runnableResults) {
          for (const item of runnableResult.items) {
            if (item.kind === "reference" /* Reference */) {
              if (seen.has(item.key)) {
                continue;
              }
              seen.add(item.key);
              const referenced = this.contextItems.get(item.key);
              if (referenced !== void 0) {
                const withPriority = Object.assign({}, referenced, { priority: runnableResult.priority });
                items.push(withPriority);
              }
            } else {
              const withPriority = Object.assign({}, item, { priority: runnableResult.priority });
              items.push(withPriority);
            }
          }
        }
        return items;
      }
      toJson() {
        const runnableResults = [];
        for (const runnableResult of this.runnableResults) {
          runnableResults.push(runnableResult.toJson());
        }
        return {
          state: this.state,
          path: this.path,
          timings: this.timings,
          errors: this.errors,
          timedOut: this.timedOut,
          exhausted: this.primaryBudget.isExhausted(),
          runnableResults,
          contextItems: Array.from(this.contextItems.values())
        };
      }
    };
    ((CacheScopes2) => {
      function fromDeclaration(declaration) {
        const body = declaration.body;
        if (body === void 0 || !ts2.isBlock(body)) {
          return void 0;
        }
        return createWithinCacheScope(body, declaration.getSourceFile());
      }
      CacheScopes2.fromDeclaration = fromDeclaration;
      function createWithinCacheScope(node, sourceFile) {
        return {
          kind: "withinRange" /* WithinRange */,
          range: createRange(node, sourceFile)
        };
      }
      CacheScopes2.createWithinCacheScope = createWithinCacheScope;
      function createOutsideCacheScope(nodes, sourceFile) {
        const ranges = [];
        for (const node of nodes) {
          ranges.push(createRange(node, sourceFile));
        }
        ranges.sort((a, b) => {
          if (a.start.line !== b.start.line) {
            return a.start.line - b.start.line;
          }
          return a.start.character - b.start.character;
        });
        return {
          kind: "outsideRange" /* OutsideRange */,
          ranges
        };
      }
      CacheScopes2.createOutsideCacheScope = createOutsideCacheScope;
      function createRange(node, sourceFile) {
        let startOffset;
        let endOffset;
        if (isNodeArray(node)) {
          startOffset = node.pos;
          endOffset = node.end;
        } else {
          startOffset = node.getStart(sourceFile);
          endOffset = node.getEnd();
          if (sourceFile === void 0) {
            sourceFile = node.getSourceFile();
          }
        }
        const start = ts2.getLineAndCharacterOfPosition(sourceFile, startOffset);
        const end = ts2.getLineAndCharacterOfPosition(sourceFile, endOffset);
        return { start, end };
      }
      CacheScopes2.createRange = createRange;
      function isNodeArray(node) {
        return Array.isArray(node);
      }
    })(CacheScopes || (CacheScopes = {}));
    CacheBasedContextRunnable = class {
      cached;
      tokenBudget;
      id;
      priority;
      cost;
      constructor(cached, priority, cost) {
        this.cached = cached;
        this.id = cached.id;
        this.priority = priority;
        this.cost = cost;
      }
      initialize(result) {
        this.tokenBudget = result.primaryBudget;
        result.addRunnableResultReference(this.cached);
      }
      compute() {
        if (this.tokenBudget === void 0) {
          return;
        }
        for (const item of this.cached.items) {
          this.tokenBudget.spent(item.sizeInChars ?? 0);
        }
      }
    };
    AbstractContextRunnable = class {
      session;
      symbols;
      id;
      location;
      priority;
      cost;
      languageService;
      context;
      program;
      result;
      constructor(session, languageService, context, id, location, priority, cost) {
        this.session = session;
        this.languageService = languageService;
        this.program = languageService.getProgram();
        this.context = context;
        this.symbols = context.getSymbols(this.getProgram());
        this.id = id;
        this.location = location;
        this.priority = priority;
        this.cost = cost;
      }
      initialize(result) {
        if (this.result !== void 0) {
          throw new Error("Runnable already initialized");
        }
        this.result = this.createRunnableResult(result);
      }
      useCachedResult(cached) {
        const cacheInfo = cached.cache;
        if (cacheInfo === void 0) {
          return false;
        }
        if (cacheInfo.emitMode === "clientBased" /* ClientBased */) {
          if (cached.state === "finished" /* Finished */) {
            return true;
          }
          if (cached.state === "isFull" /* IsFull */) {
            const kind = cached.cache?.scope.kind;
            if (kind === "withinRange" /* WithinRange */ || kind === "neighborFiles" /* NeighborFiles */ || kind === "file" /* File */) {
              return true;
            }
          }
        }
        return false;
      }
      compute(token) {
        if (this.result === void 0) {
          throw new Error("Runnable not initialized");
        }
        token.throwIfCancellationRequested();
        if (this.result.isPrimaryBudgetExhausted()) {
          return;
        }
        this.run(this.result, token);
        this.result.done();
      }
      getProgram() {
        if (this.program === void 0) {
          throw new RecoverableError("No program available", RecoverableError.NoProgram);
        }
        return this.program;
      }
      createCacheScope(node, sourceFile) {
        return CacheScopes.createWithinCacheScope(node, sourceFile);
      }
      addScopeNode(scopeNodes, symbol, kind, sourceFile) {
        const declarations = symbol.getDeclarations();
        if (declarations === void 0) {
          return void 0;
        }
        let scopeNode = void 0;
        let outsideDeclarations = 0;
        for (const declaration of declarations) {
          if (declaration.getSourceFile() !== sourceFile) {
            outsideDeclarations++;
            continue;
          }
          const parent = import_typescripts2.default.Nodes.getParentOfKind(declaration, kind);
          if (parent === void 0) {
            return void 0;
          }
          if (scopeNode === void 0) {
            scopeNode = parent;
          } else if (scopeNode !== parent) {
            return void 0;
          }
        }
        if (outsideDeclarations < declarations.length) {
          if (scopeNode !== void 0) {
            scopeNodes.add(scopeNode);
          } else {
            return void 0;
          }
        }
        return scopeNodes;
      }
      createCacheInfo(emitMode, cacheScope) {
        return cacheScope !== void 0 ? { emitMode, scope: cacheScope } : void 0;
      }
      handleSymbol(symbol, name, ifRoom) {
        if (this.result === void 0) {
          return true;
        }
        const symbolsToEmit = this.getEmitDataForSymbol(symbol, name);
        if (symbolsToEmit.length === 0) {
          return true;
        }
        for (const emitData of symbolsToEmit) {
          if (emitData.kind === "typeAlias" /* typeAlias */) {
            if (this.skipNode(emitData.node)) {
              continue;
            }
            const snippetBuilder = new CodeSnippetBuilder(this.context, this.symbols, this.getActiveSourceFile());
            snippetBuilder.addDeclaration(emitData.node);
            if (ifRoom === void 0 || ifRoom === false) {
              this.result.addSnippet(snippetBuilder, this.location, void 0);
            } else {
              if (!this.result.addSnippet(snippetBuilder, this.location, void 0, ifRoom)) {
                return false;
              }
            }
          } else if (emitData.kind === "symbol" /* symbol */) {
            const { symbol: symbol2, name: name2 } = emitData;
            if (this.skipSymbolBasedOnDeclaration(symbol2) || import_typescripts2.Symbols.isTypeParameter(symbol2)) {
              continue;
            }
            const key = import_typescripts2.Symbols.createKey(symbol2, this.session.host);
            if (key !== void 0 && this.result.addFromKnownItems(key)) {
              continue;
            }
            const snippetBuilder = new CodeSnippetBuilder(this.context, this.symbols, this.getActiveSourceFile());
            snippetBuilder.addTypeSymbol(symbol2, name2);
            if (ifRoom === void 0 || ifRoom === false) {
              this.result.addSnippet(snippetBuilder, this.location, key);
            } else {
              if (!this.result.addSnippet(snippetBuilder, this.location, key, ifRoom)) {
                return false;
              }
            }
          }
        }
        return true;
      }
      isNodeArray(node) {
        return Array.isArray(node);
      }
      skipNode(node) {
        return this.skipSourceFile(node.getSourceFile());
      }
      skipSourceFile(sourceFile) {
        if (this.getActiveSourceFile().fileName === sourceFile.fileName) {
          return true;
        }
        const program = this.getProgram();
        return program.isSourceFileDefaultLibrary(sourceFile) || program.isSourceFileFromExternalLibrary(sourceFile);
      }
      skipSymbolBasedOnDeclaration(symbol) {
        const declarations = symbol.getDeclarations();
        if (declarations === void 0 || declarations.length === 0) {
          return false;
        }
        for (const declaration of declarations) {
          if (this.skipSourceFile(declaration.getSourceFile())) {
            return true;
          }
        }
        return false;
      }
      getSymbolsForTypeNode(node) {
        const result = [];
        this.doGetSymbolsForTypeNode(result, node);
        return result;
      }
      doGetSymbolsForTypeNode(result, node) {
        if (ts2.isTypeReferenceNode(node)) {
          const symbol = this.symbols.getLeafSymbolAtLocation(node.typeName);
          if (symbol !== void 0) {
            result.push({ symbol, name: node.typeName.getText() });
          }
        } else if (ts2.isUnionTypeNode(node) || ts2.isIntersectionTypeNode(node)) {
          for (const type of node.types) {
            this.doGetSymbolsForTypeNode(result, type);
          }
        }
      }
      getSymbolsToEmitForType(type) {
        const result = [];
        this.doGetSymbolsForType(result, type);
        return result;
      }
      doGetSymbolsForType(result, type) {
        const symbol = type.getSymbol();
        if (symbol !== void 0) {
          result.push({ symbol, name: symbol.getName() });
        } else if (import_typescripts2.Types.isIntersection(type) || import_typescripts2.Types.isUnion(type)) {
          for (const item of type.types) {
            this.doGetSymbolsForType(result, item);
          }
        }
      }
      getEmitDataForSymbol(symbol, name) {
        const result = [];
        this.doGetEmitDataForSymbol(result, /* @__PURE__ */ new Set(), 0, symbol, name);
        return result;
      }
      doGetEmitDataForSymbol(result, seen, level, symbol, name) {
        if (import_typescripts2.Symbols.isAlias(symbol)) {
          symbol = this.symbols.getLeafSymbol(symbol);
        }
        if (seen.has(symbol) || level > 2) {
          return;
        }
        seen.add(symbol);
        if (import_typescripts2.Symbols.isTypeAlias(symbol)) {
          const declarations = symbol.getDeclarations();
          if (declarations === void 0 || declarations.length === 0) {
            return;
          }
          let declaration = void 0;
          for (const decl of declarations) {
            if (ts2.isTypeAliasDeclaration(decl)) {
              declaration = decl;
              break;
            }
          }
          if (declaration === void 0) {
            return;
          }
          name = name ?? declaration.name.getText();
          const type = declaration.type;
          if (ts2.isTypeLiteralNode(type)) {
            const symbol2 = this.symbols.getLeafSymbolAtLocation(type);
            if (symbol2 !== void 0) {
              if (seen.has(symbol2)) {
                return;
              }
              result.push({ kind: "symbol" /* symbol */, symbol: symbol2, name });
            }
          } else if (ts2.isTypeReferenceNode(type)) {
            const symbol2 = this.symbols.getLeafSymbolAtLocation(type.typeName);
            if (symbol2 !== void 0) {
              if (seen.has(symbol2)) {
                return;
              }
              this.doGetEmitDataForSymbol(result, seen, level + 1, symbol2, name);
            }
          } else if (ts2.isUnionTypeNode(type) || ts2.isIntersectionTypeNode(type)) {
            result.push({ kind: "typeAlias" /* typeAlias */, node: declaration });
            if (level >= 2) {
              return;
            }
            for (const item of type.types) {
              const symbol2 = this.symbols.getLeafSymbolAtLocation(item);
              if (symbol2 !== void 0) {
                if (seen.has(symbol2)) {
                  continue;
                }
                if (!import_typescripts2.Symbols.isTypeLiteral(symbol2)) {
                  this.doGetEmitDataForSymbol(result, seen, level + 1, symbol2, name);
                }
              } else {
                const symbolData = this.getSymbolsForTypeNode(item);
                for (const { symbol: symbol3, name: name2 } of symbolData) {
                  if (seen.has(symbol3)) {
                    continue;
                  }
                  this.doGetEmitDataForSymbol(result, seen, level + 1, symbol3, name2);
                }
              }
            }
          }
        } else {
          result.push({ kind: "symbol" /* symbol */, symbol, name });
        }
      }
    };
    ContextRunnableCollector = class {
      cachedRunnableResults;
      primary;
      secondary;
      tertiary;
      constructor(cachedRunnableResults) {
        this.cachedRunnableResults = cachedRunnableResults;
        this.primary = [];
        this.secondary = [];
        this.tertiary = [];
      }
      addPrimary(runnable) {
        this.primary.push(this.useCachedRunnableIfPossible(runnable));
      }
      addSecondary(runnable) {
        this.secondary.push(this.useCachedRunnableIfPossible(runnable));
      }
      addTertiary(runnable) {
        this.tertiary.push(this.useCachedRunnableIfPossible(runnable));
      }
      *entries() {
        for (const runnable of this.primary) {
          yield runnable;
        }
        for (const runnable of this.secondary) {
          yield runnable;
        }
        for (const runnable of this.tertiary) {
          yield runnable;
        }
      }
      getPrimaryRunnables() {
        return this.primary.sort((a, b) => {
          const result = a.cost - b.cost;
          if (result !== 0) {
            return result;
          }
          return b.priority - a.priority;
        });
      }
      getSecondaryRunnables() {
        return this.secondary.sort((a, b) => {
          const result = a.cost - b.cost;
          if (result !== 0) {
            return result;
          }
          return b.priority - a.priority;
        });
      }
      getTertiaryRunnables() {
        return this.tertiary.sort((a, b) => {
          const result = a.cost - b.cost;
          if (result !== 0) {
            return result;
          }
          return b.priority - a.priority;
        });
      }
      useCachedRunnableIfPossible(runnable) {
        const cached = this.cachedRunnableResults.get(runnable.id);
        if (cached === void 0) {
          return runnable;
        }
        return runnable.useCachedResult(cached) ? new CacheBasedContextRunnable(cached, runnable.priority, runnable.cost) : runnable;
      }
    };
    ContextProvider = class {
      constructor() {
      }
      isCallableProvider;
    };
    TokenBudgetExhaustedError = class extends Error {
      constructor() {
        super("Budget exhausted");
      }
    };
    CharacterBudget = class {
      charBudget;
      lowWaterMark;
      itemRejected;
      constructor(budget, lowWaterMark = 256) {
        this.charBudget = budget;
        this.lowWaterMark = lowWaterMark;
        this.itemRejected = false;
      }
      spent(chars) {
        this.charBudget -= chars;
      }
      hasRoom(chars) {
        const result = this.charBudget - this.lowWaterMark >= chars;
        if (!result) {
          this.itemRejected = true;
        }
        return result;
      }
      isExhausted() {
        return this.charBudget <= 0;
      }
      wasItemRejected() {
        return this.itemRejected;
      }
      throwIfExhausted() {
        if (this.charBudget <= 0) {
          throw new TokenBudgetExhaustedError();
        }
      }
      spentAndThrowIfExhausted(chars) {
        this.spent(chars);
        this.throwIfExhausted();
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/baseContextProviders.ts
var import_typescripts3, ts3, CompilerOptionsRunnable, FunctionLikeContextRunnable, SignatureRunnable, TypeOfLocalsRunnable, TypesOfNeighborFilesRunnable, ImportsRunnable, TypeOfExpressionRunnable, FunctionLikeContextProvider;
var init_baseContextProviders = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/baseContextProviders.ts"() {
    "use strict";
    init_typescript();
    init_code();
    init_contextProvider();
    init_protocol();
    import_typescripts3 = __toESM(require_typescripts());
    ts3 = typescript_default();
    CompilerOptionsRunnable = class _CompilerOptionsRunnable extends AbstractContextRunnable {
      static VersionTraitKey = Trait.createContextItemKey("version" /* Version */);
      // Traits to collect from the compiler options in the format of [trait kind, trait description, context key, CompilerOptions.enumType (if applicable)]
      static traitsToCollect = [
        ["module" /* Module */, "The TypeScript module system used in this project is ", Trait.createContextItemKey("module" /* Module */), ts3.ModuleKind],
        ["moduleResolution" /* ModuleResolution */, "The TypeScript module resolution strategy used in this project is ", Trait.createContextItemKey("moduleResolution" /* ModuleResolution */), ts3.ModuleResolutionKind],
        ["target" /* Target */, "The target version of JavaScript for this project is ", Trait.createContextItemKey("target" /* Target */), ts3.ScriptTarget],
        ["lib" /* Lib */, "Library files that should be included in TypeScript compilation are ", Trait.createContextItemKey("lib" /* Lib */), void 0]
      ];
      sourceFile;
      constructor(session, languageService, context, sourceFile) {
        super(session, languageService, context, "CompilerOptionsRunnable", 0 /* Primary */, 0.7 /* Traits */, 1 /* Low */);
        this.sourceFile = sourceFile;
      }
      getActiveSourceFile() {
        return this.sourceFile;
      }
      createRunnableResult(result) {
        const cacheInfo = { emitMode: "clientBased" /* ClientBased */, scope: { kind: "file" /* File */ } };
        return result.createRunnableResult(this.id, this.priority, "emit" /* emit */, cacheInfo);
      }
      run(result, _token) {
        const compilerOptions = this.getProgram().getCompilerOptions();
        if (!result.addFromKnownItems(_CompilerOptionsRunnable.VersionTraitKey)) {
          result.addTrait("version" /* Version */, "The TypeScript version used in this project is ", ts3.version);
        }
        for (const [traitKind, trait, key, enumType] of _CompilerOptionsRunnable.traitsToCollect) {
          if (result.addFromKnownItems(key)) {
            continue;
          }
          let traitValue = compilerOptions[traitKind];
          if (traitValue) {
            if (typeof traitValue === "number") {
              const enumName = _CompilerOptionsRunnable.getEnumName(enumType, traitValue);
              if (enumName) {
                traitValue = enumName;
              }
            }
            result.addTrait(traitKind, trait, traitValue.toString());
          }
        }
      }
      static getEnumName(enumObj, value) {
        return Object.keys(enumObj).find((key) => enumObj[key] === value);
      }
    };
    FunctionLikeContextRunnable = class extends AbstractContextRunnable {
      declaration;
      sourceFile;
      constructor(session, languageService, context, id, declaration, priority, cost) {
        super(session, languageService, context, id, 0 /* Primary */, priority, cost);
        this.declaration = declaration;
        this.sourceFile = declaration.getSourceFile();
      }
      getActiveSourceFile() {
        return this.sourceFile;
      }
      getCacheScope() {
        const body = this.declaration.body;
        if (body === void 0 || !ts3.isBlock(body)) {
          return void 0;
        }
        return super.createCacheScope(body, this.sourceFile);
      }
    };
    SignatureRunnable = class _SignatureRunnable extends FunctionLikeContextRunnable {
      constructor(session, languageService, context, declaration, priority = 0.9 /* Locals */) {
        super(session, languageService, context, _SignatureRunnable.computeId(session, declaration), declaration, priority, 1 /* Low */);
      }
      createRunnableResult(result) {
        const scope = this.getCacheScope();
        const cacheInfo = scope !== void 0 ? { emitMode: "clientBased" /* ClientBased */, scope } : void 0;
        return result.createRunnableResult(this.id, this.priority, "emit" /* emit */, cacheInfo);
      }
      run(result, token) {
        const parameters = this.declaration.parameters;
        for (let i = 0; i < parameters.length; i++) {
          token.throwIfCancellationRequested();
          const parameter = this.declaration.parameters[i];
          const type = parameter.type;
          if (type === void 0) {
            continue;
          }
          this.processType(result, type, token);
        }
        const returnType = this.declaration.type;
        if (returnType !== void 0) {
          token.throwIfCancellationRequested();
          this.processType(result, returnType, token);
        }
      }
      processType(_result, type, token) {
        const symbolsToEmit = this.getSymbolsForTypeNode(type);
        if (symbolsToEmit.length === 0) {
          return;
        }
        for (const symbolEmitData of symbolsToEmit) {
          token.throwIfCancellationRequested();
          this.handleSymbol(symbolEmitData.symbol, symbolEmitData.name);
        }
      }
      static computeId(session, declaration) {
        const host = session.host;
        const startPos = declaration.parameters.pos;
        const endPos = declaration.type?.end ?? declaration.parameters.end;
        if (host.isDebugging()) {
          const sourceFile = declaration.getSourceFile();
          const start = ts3.getLineAndCharacterOfPosition(sourceFile, startPos);
          const end = ts3.getLineAndCharacterOfPosition(sourceFile, endPos);
          return `SignatureRunnable:${declaration.getSourceFile().fileName}:[${start.line},${start.character},${end.line},${end.character}]`;
        } else {
          const hash = session.host.createHash("md5");
          const sourceFile = declaration.getSourceFile();
          hash.update(sourceFile.fileName);
          hash.update(`[${startPos},${endPos}]`);
          return `SignatureRunnable:${hash.digest("base64")}`;
        }
      }
    };
    TypeOfLocalsRunnable = class extends AbstractContextRunnable {
      tokenInfo;
      excludes;
      cacheScope;
      runnableResult;
      constructor(session, languageService, context, tokenInfo, excludes, cacheScope, priority = 0.9 /* Locals */) {
        super(session, languageService, context, "TypeOfLocalsRunnable", 0 /* Primary */, priority, 2 /* Medium */);
        this.tokenInfo = tokenInfo;
        this.excludes = excludes;
        this.cacheScope = cacheScope;
        this.runnableResult = void 0;
      }
      getActiveSourceFile() {
        return this.tokenInfo.token.getSourceFile();
      }
      createRunnableResult(result) {
        const cacheInfo = this.cacheScope !== void 0 ? { emitMode: "clientBasedOnTimeout" /* ClientBasedOnTimeout */, scope: this.cacheScope } : void 0;
        this.runnableResult = result.createRunnableResult(this.id, this.priority, "emit" /* emit */, cacheInfo);
        return this.runnableResult;
      }
      run(_result, cancellationToken) {
        const token = this.tokenInfo.previous ?? this.tokenInfo.token ?? this.tokenInfo.touching;
        const symbols = this.symbols;
        const typeChecker = symbols.getTypeChecker();
        const inScope = typeChecker.getSymbolsInScope(token, ts3.SymbolFlags.BlockScopedVariable);
        if (inScope.length === 0) {
          return;
        }
        const sourceFile = token.getSourceFile();
        let variableDeclarations = this.cacheScope === void 0 ? /* @__PURE__ */ new Set() : void 0;
        for (const symbol of inScope) {
          cancellationToken.throwIfCancellationRequested();
          if (this.excludes.has(symbol)) {
            continue;
          }
          const declaration = import_typescripts3.Symbols.getDeclaration(symbol, ts3.SyntaxKind.VariableDeclaration);
          if (declaration === void 0) {
            continue;
          }
          let symbolsToEmit = void 0;
          if (declaration.type !== void 0) {
            symbolsToEmit = this.getSymbolsForTypeNode(declaration.type);
          } else {
            const type = typeChecker.getTypeAtLocation(declaration.type ?? declaration);
            if (type !== void 0) {
              symbolsToEmit = this.getSymbolsToEmitForType(type);
            }
          }
          if (symbolsToEmit === void 0 || symbolsToEmit.length === 0) {
            continue;
          }
          for (const { symbol: symbol2, name } of symbolsToEmit) {
            cancellationToken.throwIfCancellationRequested();
            this.handleSymbol(symbol2, name);
          }
          if (variableDeclarations !== void 0) {
            variableDeclarations = this.addScopeNode(variableDeclarations, symbol, ts3.SyntaxKind.VariableDeclarationList, sourceFile);
          }
        }
        if (variableDeclarations !== void 0 && variableDeclarations.size > 0 && this.runnableResult !== void 0) {
          this.runnableResult.setCacheInfo({ emitMode: "clientBasedOnTimeout" /* ClientBasedOnTimeout */, scope: CacheScopes.createOutsideCacheScope(variableDeclarations, sourceFile) });
        }
      }
    };
    TypesOfNeighborFilesRunnable = class _TypesOfNeighborFilesRunnable extends AbstractContextRunnable {
      tokenInfo;
      static SymbolsToInclude = ts3.SymbolFlags.Class | ts3.SymbolFlags.Interface | ts3.SymbolFlags.TypeAlias | ts3.SymbolFlags.Enum | ts3.SymbolFlags.Function;
      constructor(session, languageService, context, tokenInfo, priority = 0.3 /* NeighborFiles */) {
        super(session, languageService, context, "TypesOfNeighborFilesRunnable", 1 /* Secondary */, priority, 2 /* Medium */);
        this.tokenInfo = tokenInfo;
      }
      getActiveSourceFile() {
        return this.tokenInfo.token.getSourceFile();
      }
      createRunnableResult(result) {
        const cacheInfo = { emitMode: "clientBased" /* ClientBased */, scope: { kind: "neighborFiles" /* NeighborFiles */ } };
        return result.createRunnableResult(this.id, this.priority, "emit" /* emit */, cacheInfo);
      }
      run(result, cancellationToken) {
        const symbols = this.symbols;
        for (const neighborFile of this.context.neighborFiles) {
          cancellationToken.throwIfCancellationRequested();
          if (result.isSecondaryBudgetExhausted()) {
            return;
          }
          const neighborSourceFile = this.getProgram().getSourceFile(neighborFile);
          if (neighborSourceFile === void 0 || this.skipSourceFile(neighborSourceFile)) {
            continue;
          }
          const sourceFileSymbol = symbols.getLeafSymbolAtLocation(neighborSourceFile);
          if (sourceFileSymbol === void 0) {
            continue;
          }
          if (sourceFileSymbol.exports !== void 0) {
            for (const member of sourceFileSymbol.exports) {
              cancellationToken.throwIfCancellationRequested();
              const memberSymbol = member[1];
              if ((memberSymbol.flags & _TypesOfNeighborFilesRunnable.SymbolsToInclude) === 0) {
                continue;
              }
              if (!this.handleSymbol(memberSymbol, member[0], true)) {
                return;
              }
            }
          }
        }
      }
    };
    ImportsRunnable = class _ImportsRunnable extends AbstractContextRunnable {
      tokenInfo;
      excludes;
      cacheInfo;
      runnableResult;
      static CacheNodes = /* @__PURE__ */ new Set([
        ts3.SyntaxKind.FunctionDeclaration,
        ts3.SyntaxKind.ArrowFunction,
        ts3.SyntaxKind.FunctionExpression,
        ts3.SyntaxKind.Constructor,
        ts3.SyntaxKind.MethodDeclaration,
        ts3.SyntaxKind.ClassDeclaration,
        ts3.SyntaxKind.ModuleDeclaration
      ]);
      constructor(session, languageService, context, tokenInfo, excludes, priority = 0.4 /* Imports */) {
        super(session, languageService, context, "ImportsRunnable", 1 /* Secondary */, priority, 2 /* Medium */);
        this.tokenInfo = tokenInfo;
        this.excludes = excludes;
        this.runnableResult = void 0;
        const scopeNode = this.getCacheScopeNode();
        this.cacheInfo = scopeNode === void 0 ? void 0 : { emitMode: "clientBased" /* ClientBased */, scope: this.createCacheScope(scopeNode) };
      }
      getActiveSourceFile() {
        return this.tokenInfo.token.getSourceFile();
      }
      useCachedResult(cached) {
        const cacheInfo = cached.cache;
        if (cacheInfo === void 0) {
          return false;
        }
        if (cacheInfo.emitMode === "clientBased" /* ClientBased */ && cached.state === "finished" /* Finished */) {
          const scope = cacheInfo.scope;
          if (scope.kind === "withinRange" /* WithinRange */) {
            return true;
          } else if (scope.kind === "outsideRange" /* OutsideRange */) {
            return this.cacheInfo === void 0;
          }
        }
        return super.useCachedResult(cached);
      }
      createRunnableResult(result) {
        this.runnableResult = result.createRunnableResult(this.id, this.priority, "emit" /* emit */, this.cacheInfo);
        return this.runnableResult;
      }
      run(result, cancellationToken) {
        cancellationToken.throwIfCancellationRequested();
        const token = this.tokenInfo.touching ?? this.tokenInfo.token;
        const sourceFile = token.getSourceFile();
        const importBlocks = this.getImportBlocks(sourceFile);
        cancellationToken.throwIfCancellationRequested();
        const importedSymbols = [];
        let outSideRanges = void 0;
        for (const block of importBlocks) {
          for (const stmt of block.imports) {
            cancellationToken.throwIfCancellationRequested();
            if (stmt.importClause === void 0) {
              continue;
            }
            const importClause = stmt.importClause;
            if (importClause.name !== void 0) {
              const symbol = this.symbols.getLeafSymbolAtLocation(importClause.name);
              if (symbol !== void 0 && !this.excludes.has(symbol)) {
                importedSymbols.push({ symbol, name: importClause.name.getText() });
              }
            } else if (importClause.namedBindings !== void 0) {
              const namedBindings = importClause.namedBindings;
              if (ts3.isNamespaceImport(namedBindings)) {
                const symbol = this.symbols.getLeafSymbolAtLocation(namedBindings.name);
                if (symbol !== void 0 && !this.excludes.has(symbol)) {
                  importedSymbols.push({ symbol, name: namedBindings.name.getText() });
                }
              } else if (ts3.isNamedImports(namedBindings)) {
                for (const element of namedBindings.elements) {
                  const symbol = this.symbols.getLeafSymbolAtLocation(element.name);
                  if (symbol !== void 0 && !this.excludes.has(symbol)) {
                    importedSymbols.push({ symbol, name: element.name.getText() });
                  }
                }
              }
            }
          }
          if (this.cacheInfo === void 0) {
            if (outSideRanges === void 0) {
              outSideRanges = [];
            }
            const start = block.before !== void 0 ? CacheScopes.createRange(block.before, sourceFile).end : CacheScopes.createRange(block.imports[0], sourceFile).start;
            const end = block.after !== void 0 ? CacheScopes.createRange(block.after, sourceFile).start : CacheScopes.createRange(block.imports[block.imports.length - 1], sourceFile).end;
            outSideRanges.push({ start, end });
          }
        }
        for (const { symbol, name } of importedSymbols) {
          const flags = symbol.flags;
          if ((flags & (ts3.SymbolFlags.Class | ts3.SymbolFlags.Interface | ts3.SymbolFlags.TypeAlias | ts3.SymbolFlags.Enum | ts3.SymbolFlags.Alias | ts3.SymbolFlags.ValueModule)) === 0) {
            continue;
          }
          if (!this.handleSymbol(symbol, name, true)) {
            break;
          }
        }
        if (this.cacheInfo === void 0 && outSideRanges !== void 0 && outSideRanges.length > 0) {
          result.setCacheInfo({ emitMode: "clientBased" /* ClientBased */, scope: { kind: "outsideRange" /* OutsideRange */, ranges: outSideRanges } });
        }
      }
      getImportBlocks(sourceFile) {
        if (this.cacheInfo !== void 0) {
          const imports = [];
          for (const node of import_typescripts3.default.Nodes.getChildren(sourceFile, sourceFile)) {
            if (ts3.isImportDeclaration(node)) {
              imports.push(node);
            }
          }
          return [{ before: void 0, imports, after: void 0 }];
        } else {
          const result = [];
          let before = void 0;
          let after = void 0;
          let imports = [];
          for (const node of import_typescripts3.default.Nodes.getChildren(sourceFile, sourceFile)) {
            if (ts3.isImportDeclaration(node)) {
              imports.push(node);
            } else {
              if (imports.length === 0) {
                before = node;
              } else {
                after = node;
                result.push({ before, imports, after });
                before = void 0;
                after = void 0;
                imports = [];
              }
            }
          }
          if (imports.length > 0) {
            result.push({ before, imports, after });
          }
          return result;
        }
      }
      getCacheScopeNode() {
        let current = this.tokenInfo.touching ?? this.tokenInfo.token;
        if (current === void 0 || current.kind === ts3.SyntaxKind.EndOfFileToken || current.kind === ts3.SyntaxKind.Unknown) {
          return void 0;
        }
        let result;
        while (current !== void 0 && current.kind !== ts3.SyntaxKind.SourceFile) {
          if (_ImportsRunnable.CacheNodes.has(current.kind)) {
            result = current;
          }
          current = current.parent;
        }
        return result;
      }
    };
    TypeOfExpressionRunnable = class _TypeOfExpressionRunnable extends AbstractContextRunnable {
      expression;
      constructor(session, languageService, context, expression, priority = 1 /* Expression */) {
        super(session, languageService, context, "TypeOfExpressionRunnable", 0 /* Primary */, priority, 1 /* Low */);
        this.expression = expression;
      }
      getActiveSourceFile() {
        return this.expression.getSourceFile();
      }
      static create(session, languageService, context, tokenInfo, _token) {
        const previous = tokenInfo.previous;
        if (previous === void 0 || previous.parent === void 0) {
          return;
        }
        if ((ts3.isIdentifier(previous) || previous.kind === ts3.SyntaxKind.DotToken) && ts3.isPropertyAccessExpression(previous.parent)) {
          const identifier = this.getRightMostIdentifier(previous.parent.expression, 0);
          if (identifier !== void 0) {
            return new _TypeOfExpressionRunnable(session, languageService, context, identifier);
          }
        }
        return void 0;
      }
      static getRightMostIdentifier(node, count) {
        if (count === 32) {
          return void 0;
        }
        switch (node.kind) {
          case ts3.SyntaxKind.Identifier:
            return node;
          case ts3.SyntaxKind.PropertyAccessExpression:
            return this.getRightMostIdentifier(node.name, count + 1);
          case ts3.SyntaxKind.ElementAccessExpression:
            return this.getRightMostIdentifier(node.argumentExpression, count + 1);
          case ts3.SyntaxKind.CallExpression:
            return this.getRightMostIdentifier(node.expression, count + 1);
          default:
            return void 0;
        }
      }
      createRunnableResult(result) {
        return result.createRunnableResult(this.id, this.priority, "ignore" /* ignore */);
      }
      run(result, token) {
        const expSymbol = this.symbols.getLeafSymbolAtLocation(this.expression);
        if (expSymbol === void 0) {
          return;
        }
        const typeChecker = this.symbols.getTypeChecker();
        const type = typeChecker.getTypeOfSymbolAtLocation(expSymbol, this.expression);
        const signatures = type.getConstructSignatures().concat(type.getCallSignatures());
        const sourceFile = this.expression.getSourceFile();
        for (const signature of signatures) {
          token.throwIfCancellationRequested();
          const returnType = signature.getReturnType();
          const returnTypeSymbol = returnType.aliasSymbol ?? returnType.getSymbol();
          if (returnTypeSymbol === void 0) {
            continue;
          }
          const snippetBuilder2 = new CodeSnippetBuilder(this.context, this.symbols, sourceFile);
          snippetBuilder2.addTypeSymbol(returnTypeSymbol, returnTypeSymbol.name);
          result.addSnippet(snippetBuilder2, this.location, void 0);
        }
        const typeSymbol = type.getSymbol();
        if (typeSymbol === void 0) {
          return;
        }
        const snippetBuilder = new CodeSnippetBuilder(this.context, this.symbols, sourceFile);
        snippetBuilder.addTypeSymbol(typeSymbol, typeSymbol.name);
        result.addSnippet(snippetBuilder, this.location, void 0);
      }
    };
    FunctionLikeContextProvider = class extends ContextProvider {
      functionLikeDeclaration;
      tokenInfo;
      computeContext;
      isCallableProvider;
      constructor(declaration, tokenInfo, computeContext2) {
        super();
        this.functionLikeDeclaration = declaration;
        this.tokenInfo = tokenInfo;
        this.computeContext = computeContext2;
        this.isCallableProvider = true;
      }
      provide(result, session, languageService, context, token) {
        token.throwIfCancellationRequested();
        result.addPrimary(new SignatureRunnable(session, languageService, context, this.functionLikeDeclaration));
        if (!this.computeContext.isFirstCallableProvider(this)) {
          return;
        }
        const excludes = this.getTypeExcludes(languageService, context);
        result.addPrimary(new TypeOfLocalsRunnable(session, languageService, context, this.tokenInfo, excludes, CacheScopes.fromDeclaration(this.functionLikeDeclaration)));
        const runnable = TypeOfExpressionRunnable.create(session, languageService, context, this.tokenInfo, token);
        if (runnable !== void 0) {
          result.addPrimary(runnable);
        }
        result.addSecondary(new ImportsRunnable(session, languageService, context, this.tokenInfo, excludes));
        if (context.neighborFiles.length > 0) {
          result.addTertiary(new TypesOfNeighborFilesRunnable(session, languageService, context, this.tokenInfo));
        }
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/classContextProvider.ts
var import_typescripts4, ts4, ClassBlueprintSearch, SuperClassRunnable, SimilarClassRunnable, ClassContextProvider, WholeClassContextProvider;
var init_classContextProvider = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/classContextProvider.ts"() {
    "use strict";
    init_typescript();
    init_code();
    init_contextProvider();
    init_protocol();
    import_typescripts4 = __toESM(require_typescripts());
    ts4 = typescript_default();
    ClassBlueprintSearch = class _ClassBlueprintSearch extends Search {
      classDeclaration;
      stateProvider;
      abstractMembers;
      extends;
      implements;
      constructor(program, symbols, classDeclarationOrSearch, stateProvider) {
        super(program, symbols);
        if (classDeclarationOrSearch instanceof _ClassBlueprintSearch) {
          const search = classDeclarationOrSearch;
          this.classDeclaration = Search.getNodeInProgram(program, search.classDeclaration);
          this.stateProvider = search.stateProvider;
          this.abstractMembers = search.abstractMembers;
          const mapTypeInfo = (typeInfo) => {
            const type = typeInfo.type;
            const sourceFile = program.getSourceFile(type.getSourceFile().fileName);
            if (sourceFile !== void 0) {
              const localType = import_typescripts4.default.getTokenAtPosition(sourceFile, type.pos);
              if (ts4.isExpressionWithTypeArguments(localType)) {
                const symbol = symbols.getLeafSymbolAtLocation(localType.expression);
                if (symbol !== void 0 && !this.getSymbolInfo(symbol).skip) {
                  return { symbol, type: localType, abstractMembers: typeInfo.abstractMembers };
                }
              }
            }
            return void 0;
          };
          if (search.extends !== void 0) {
            this.extends = mapTypeInfo(search.extends);
          }
          if (search.implements !== void 0) {
            let impl;
            for (const info of search.implements) {
              const mapped = mapTypeInfo(info);
              if (mapped !== void 0) {
                impl = impl ?? [];
                impl.push(mapped);
              }
            }
            this.implements = impl;
          }
        } else {
          const classDeclaration = classDeclarationOrSearch;
          this.classDeclaration = classDeclaration;
          this.stateProvider = stateProvider;
          const heritageClauses = classDeclaration.heritageClauses;
          if (heritageClauses === void 0) {
            this.abstractMembers = 0;
            this.extends = void 0;
            this.implements = void 0;
            return;
          }
          let totalAbstractMembers = 0;
          let extendsSymbol;
          let implementsSymbols;
          for (const heritageClause of heritageClauses) {
            if (heritageClause.token === ts4.SyntaxKind.ExtendsKeyword) {
              if (heritageClause.types.length === 1) {
                const type = heritageClause.types[0];
                const symbol = this.getHeritageSymbol(type.expression);
                if (symbol !== void 0 && !this.getSymbolInfo(symbol).skip) {
                  const abstractMembers = this.getNumberOfAbstractMembers(symbol);
                  totalAbstractMembers += abstractMembers;
                  extendsSymbol = { symbol, type, abstractMembers };
                }
              }
            } else if (heritageClause.token === ts4.SyntaxKind.ImplementsKeyword) {
              for (const type of heritageClause.types) {
                const symbol = this.getHeritageSymbol(type.expression);
                if (symbol !== void 0 && !this.getSymbolInfo(symbol).skip) {
                  implementsSymbols = implementsSymbols ?? [];
                  const abstractMembers = this.getNumberOfAbstractMembers(symbol);
                  totalAbstractMembers += abstractMembers;
                  implementsSymbols.push({ symbol, type, abstractMembers });
                }
              }
            }
          }
          if (implementsSymbols !== void 0) {
            implementsSymbols.sort((a, b) => b.abstractMembers - a.abstractMembers);
          }
          this.abstractMembers = totalAbstractMembers;
          this.extends = extendsSymbol;
          this.implements = implementsSymbols;
        }
      }
      with(program) {
        if (program === this.program) {
          return this;
        }
        return new _ClassBlueprintSearch(program, new import_typescripts4.Symbols(program), this);
      }
      *all() {
        if (this.extends !== void 0) {
          yield this.extends;
        }
        if (this.implements !== void 0) {
          yield* this.implements;
        }
      }
      isSame(other) {
        return this.classDeclaration === other || this.classDeclaration.getSourceFile().fileName === other.getSourceFile().fileName && this.classDeclaration.pos === other.pos;
      }
      score(program, context) {
        if (this.abstractMembers === 0) {
          if (this.extends === void 0) {
            return -1;
          }
          const declarations = this.extends.symbol.declarations;
          if (declarations === void 0) {
            return -1;
          }
          for (const declaration of declarations) {
            if (program.getSourceFile(declaration.getSourceFile().fileName) === void 0) {
              return -1;
            }
          }
          return 1;
        }
        let possible = void 0;
        for (const info of this.all()) {
          if (info.symbol.declarations === void 0) {
            continue;
          }
          for (const declaration of info.symbol.declarations) {
            const sourceFile = declaration.getSourceFile();
            if (program.getSourceFile(sourceFile.fileName) !== void 0) {
              possible ??= 0;
              possible += info.abstractMembers;
              break;
            }
          }
        }
        if (possible === void 0) {
          return -1;
        }
        let result = possible / this.abstractMembers;
        const neighborFiles = context.neighborFiles;
        if (neighborFiles.length === 0) {
          return result;
        }
        const factor = Math.pow(10, neighborFiles.length.toString().length);
        result *= factor;
        for (const file of neighborFiles) {
          if (program.getSourceFile(file) !== void 0) {
            result += 1;
          }
        }
        return result;
      }
      run(context, token) {
        if (this.extends === void 0 && this.implements === void 0) {
          return void 0;
        }
        let result;
        const symbol2TypeInfo = new Map([...this.all()].map((info) => [info.symbol, info]));
        for (const typeInfo of this.all()) {
          const symbol = typeInfo.symbol;
          const declarations = symbol.declarations;
          if (declarations === void 0) {
            continue;
          }
          const declarationSourceFileVisited = /* @__PURE__ */ new Set();
          for (const declaration of declarations) {
            if (!ts4.isClassDeclaration(declaration) && !ts4.isInterfaceDeclaration(declaration) && !ts4.isTypeAliasDeclaration(declaration) || declaration.name === void 0) {
              continue;
            }
            const declarationSourceFile = declaration.getSourceFile();
            if (declarationSourceFileVisited.has(declarationSourceFile.fileName)) {
              continue;
            }
            const referencedByVisitor = new import_typescripts4.ReferencedByVisitor(this.program, declarationSourceFile, context.getPreferredNeighborFiles(this.program), this.stateProvider, token);
            for (const sourceFile of referencedByVisitor.entries()) {
              token.throwIfCancellationRequested();
              for (const candidate of import_typescripts4.ClassDeclarations.entries(sourceFile)) {
                if (candidate.heritageClauses === void 0) {
                  continue;
                }
                if (this.isSame(candidate)) {
                  continue;
                }
                let matchesAbstractMembers = void 0;
                for (const heritageClause of candidate.heritageClauses) {
                  for (const type of heritageClause.types) {
                    const symbol2 = this.getHeritageSymbol(type.expression);
                    if (symbol2 === void 0) {
                      continue;
                    }
                    const typeInfo2 = symbol2TypeInfo.get(symbol2);
                    if (typeInfo2 === void 0) {
                      continue;
                    }
                    matchesAbstractMembers ??= 0;
                    matchesAbstractMembers += typeInfo2.abstractMembers;
                  }
                }
                if (matchesAbstractMembers !== void 0) {
                  if (result === void 0) {
                    result = { declaration: candidate, matchesAbstractMembers };
                  } else if (matchesAbstractMembers > result.matchesAbstractMembers) {
                    result = { declaration: candidate, matchesAbstractMembers };
                  }
                }
                if (result !== void 0 && result.matchesAbstractMembers === this.abstractMembers) {
                  return result;
                }
              }
            }
          }
        }
        return void 0;
      }
      getNumberOfAbstractMembers(symbol) {
        const stats = this.symbols.getMemberStatistic(symbol);
        return stats.abstract.size;
      }
    };
    SuperClassRunnable = class extends AbstractContextRunnable {
      classDeclaration;
      constructor(session, languageService, context, classDeclaration, priority = 0.8 /* Inherited */) {
        super(session, languageService, context, "SuperClassRunnable", 0 /* Primary */, priority, 2 /* Medium */);
        this.classDeclaration = classDeclaration;
      }
      getActiveSourceFile() {
        return this.classDeclaration.getSourceFile();
      }
      createRunnableResult(result) {
        const cacheScope = this.createCacheScope(this.classDeclaration.members, this.classDeclaration.getSourceFile());
        return result.createRunnableResult(this.id, this.priority, "emit" /* emit */, { emitMode: "clientBased" /* ClientBased */, scope: cacheScope });
      }
      run(_result, _token) {
        const symbols = this.symbols;
        const clazz = symbols.getLeafSymbolAtLocation(this.classDeclaration.name ?? this.classDeclaration);
        if (clazz === void 0 || !import_typescripts4.Symbols.isClass(clazz) || clazz.declarations === void 0) {
          return;
        }
        const directSuperSymbolInfo = symbols.getDirectSuperSymbols(clazz);
        if (directSuperSymbolInfo === void 0) {
          return;
        }
        if (directSuperSymbolInfo.extends !== void 0) {
          const { symbol, name } = directSuperSymbolInfo.extends;
          if (symbol !== void 0 && name !== void 0) {
            this.handleSymbol(symbol, name);
          }
        }
        if (directSuperSymbolInfo.implements !== void 0) {
          for (const impl of directSuperSymbolInfo.implements) {
            const { symbol, name } = impl;
            if (symbol !== void 0 && name !== void 0) {
              this.handleSymbol(symbol, name);
            }
          }
        }
      }
    };
    SimilarClassRunnable = class extends AbstractContextRunnable {
      classDeclaration;
      constructor(session, languageService, context, classDeclaration, priority = 0.6 /* Blueprints */) {
        super(session, languageService, context, "SimilarClassRunnable", 0 /* Primary */, priority, 3 /* High */);
        this.classDeclaration = classDeclaration;
      }
      getActiveSourceFile() {
        return this.classDeclaration.getSourceFile();
      }
      createRunnableResult(result) {
        return result.createRunnableResult(this.id, this.priority, "emit" /* emit */);
      }
      run(result, token) {
        const program = this.getProgram();
        const classDeclaration = this.classDeclaration;
        const symbol = this.symbols.getLeafSymbolAtLocation(classDeclaration.name ?? classDeclaration);
        if (symbol === void 0 || !import_typescripts4.Symbols.isClass(symbol)) {
          return;
        }
        const search = new ClassBlueprintSearch(program, this.symbols, classDeclaration);
        if (search.extends === void 0 && search.implements === void 0) {
          return;
        }
        const [foundInProgram, similarClass] = this.session.run(search, this.context, token);
        if (foundInProgram === void 0 || similarClass === void 0) {
          return;
        }
        const code = new CodeSnippetBuilder(this.context, this.context.getSymbols(foundInProgram), classDeclaration.getSourceFile());
        code.addDeclaration(similarClass.declaration);
        result.addSnippet(code, this.location, void 0);
      }
    };
    ClassContextProvider = class _ClassContextProvider extends ContextProvider {
      static create(declaration, tokenInfo) {
        if (declaration.members === void 0 || declaration.members.length === 0) {
          return new WholeClassContextProvider(declaration, tokenInfo);
        } else {
          return new _ClassContextProvider(declaration, tokenInfo);
        }
      }
      classDeclaration;
      constructor(classDeclaration, _tokenInfo) {
        super();
        this.classDeclaration = classDeclaration;
      }
      provide(result, session, languageService, context, token) {
        token.throwIfCancellationRequested();
        result.addPrimary(
          new SuperClassRunnable(session, languageService, context, this.classDeclaration)
        );
      }
    };
    WholeClassContextProvider = class extends ContextProvider {
      classDeclaration;
      constructor(classDeclaration, _tokenInfo) {
        super();
        this.classDeclaration = classDeclaration;
      }
      provide(result, session, languageService, context, token) {
        token.throwIfCancellationRequested();
        result.addPrimary(
          new SuperClassRunnable(session, languageService, context, this.classDeclaration)
        );
        if (session.enableBlueprintSearch()) {
          result.addPrimary(new SimilarClassRunnable(session, languageService, context, this.classDeclaration));
        }
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/functionContextProvider.ts
var FunctionContextProvider;
var init_functionContextProvider = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/functionContextProvider.ts"() {
    "use strict";
    init_baseContextProviders();
    FunctionContextProvider = class extends FunctionLikeContextProvider {
      functionDeclaration;
      constructor(functionDeclaration, tokenInfo, computeContext2) {
        super(functionDeclaration, tokenInfo, computeContext2);
        this.functionDeclaration = functionDeclaration;
      }
      provide(result, session, languageService, context, token) {
        super.provide(result, session, languageService, context, token);
      }
      getTypeExcludes() {
        return /* @__PURE__ */ new Set();
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/methodContextProvider.ts
var import_typescripts5, ts5, ClassPropertyBlueprintSearch, MethodBlueprintSearch, FindInSiblingClassSearch, PrivateMethodBlueprintSearch, FindMethodInSubclassSearch, FindMethodInHierarchySearch, SimilarPropertyRunnable, SimilarMethodRunnable, ClassPropertyContextProvider, PropertiesTypeRunnable, MethodContextProvider, AccessorProvider, ConstructorBlueprintSearch, SimilarConstructorRunnable, ConstructorContextProvider;
var init_methodContextProvider = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/methodContextProvider.ts"() {
    "use strict";
    init_typescript();
    init_baseContextProviders();
    init_code();
    init_contextProvider();
    init_protocol();
    init_types();
    import_typescripts5 = __toESM(require_typescripts());
    ts5 = typescript_default();
    ClassPropertyBlueprintSearch = class extends Search {
      declaration;
      stateProvider;
      constructor(program, symbols, declaration, stateProvider) {
        super(program, symbols);
        this.declaration = declaration;
        this.stateProvider = stateProvider;
      }
      isSame(other) {
        return this.declaration === other || this.declaration.getSourceFile().fileName === other.getSourceFile().fileName && this.declaration.pos === other.pos;
      }
      score(program, context) {
        if (program.getSourceFile(this.declaration.getSourceFile().fileName) === void 0) {
          return 0;
        }
        const neighborFiles = context.neighborFiles;
        if (neighborFiles.length === 0) {
          return 1;
        }
        let result = Math.pow(10, neighborFiles.length.toString().length);
        for (const file of neighborFiles) {
          if (program.getSourceFile(file) !== void 0) {
            result += 1;
          }
        }
        return result;
      }
    };
    MethodBlueprintSearch = class extends ClassPropertyBlueprintSearch {
      constructor(program, symbols, declaration, stateProvider) {
        super(program, symbols, declaration, stateProvider);
      }
      static create(program, symbols, declaration, stateProvider) {
        const classDeclaration = declaration.parent;
        if (!ts5.isClassDeclaration(classDeclaration)) {
          return void 0;
        }
        const isPrivate = import_typescripts5.Declarations.isPrivate(declaration);
        const typesToCheck = [];
        let classToCheck = void 0;
        if (!isPrivate) {
          const symbol = symbols.getLeafSymbolAtLocation(classDeclaration.name !== void 0 ? classDeclaration.name : classDeclaration);
          if (symbol === void 0 || !import_typescripts5.Symbols.isClass(symbol)) {
            return void 0;
          }
          const name = ts5.escapeLeadingUnderscores(declaration.name.getText());
          let path = void 0;
          let skip = false;
          for (const [typeSymbol, superTypeSymbol] of symbols.getAllSuperTypesWithPath(symbol)) {
            if (symbol === typeSymbol) {
              skip = false;
              path = [];
            }
            if (skip) {
              continue;
            }
            path.push(superTypeSymbol);
            const method = superTypeSymbol.members?.get(name);
            if (method !== void 0) {
              if (import_typescripts5.Symbols.isInterface(superTypeSymbol) || import_typescripts5.Symbols.isTypeLiteral(superTypeSymbol)) {
                typesToCheck.push(...path);
                skip = true;
              } else if (import_typescripts5.Symbols.isClass(superTypeSymbol)) {
                if (import_typescripts5.Symbols.isAbstract(method)) {
                  classToCheck = superTypeSymbol;
                  break;
                } else {
                  classToCheck = superTypeSymbol;
                  break;
                }
              }
            }
          }
        }
        if (isPrivate) {
          const extendsClause = import_typescripts5.ClassDeclarations.getExtendsClause(classDeclaration);
          if (extendsClause === void 0 || extendsClause.types.length === 0) {
            return void 0;
          } else {
            const extendsSymbol = symbols.getLeafSymbolAtLocation(extendsClause.types[0].expression);
            if (extendsSymbol === void 0 || !import_typescripts5.Symbols.isClass(extendsSymbol)) {
              return void 0;
            }
            return new PrivateMethodBlueprintSearch(program, symbols, classDeclaration, extendsSymbol, declaration, stateProvider);
          }
        } else {
          if (classToCheck !== void 0) {
            return new FindMethodInSubclassSearch(program, symbols, classDeclaration, declaration, classToCheck, stateProvider);
          } else if (typesToCheck.length > 0) {
            const filteredTypesToCheck = typesToCheck.filter((symbol) => {
              if (import_typescripts5.Symbols.isTypeLiteral(symbol)) {
                return false;
              }
              const name = symbol.escapedName;
              if (name === "__type" || name === "__class") {
                return false;
              }
              return true;
            });
            return new FindMethodInHierarchySearch(program, symbols, classDeclaration, declaration, filteredTypesToCheck, stateProvider);
          } else {
            return void 0;
          }
        }
      }
    };
    FindInSiblingClassSearch = class _FindInSiblingClassSearch extends ClassPropertyBlueprintSearch {
      classDeclaration;
      extendsSymbol;
      constructor(program, symbols, classDeclarationOrSearch, extendsSymbol, declaration, stateProvider) {
        if (classDeclarationOrSearch instanceof _FindInSiblingClassSearch) {
          const search = classDeclarationOrSearch;
          const methodDeclaration = Search.getNodeInProgram(program, search.declaration);
          super(program, symbols, methodDeclaration, search.stateProvider);
          this.classDeclaration = Search.getNodeInProgram(program, search.classDeclaration);
          const declarations = search.extendsSymbol.declarations;
          if (declarations === void 0 || declarations.length === 0) {
            throw new Error("No declarations found for extends symbol");
          }
          let extendsSymbol2;
          for (const declaration2 of declarations) {
            if (ts5.isClassDeclaration(declaration2)) {
              const heritageClause = import_typescripts5.ClassDeclarations.getExtendsClause(declaration2);
              if (heritageClause === void 0 || heritageClause.types.length === 0) {
                throw new Error("No extends clause found");
              }
              extendsSymbol2 = this.symbols.getLeafSymbolAtLocation(heritageClause.types[0].expression);
              if (extendsSymbol2 === void 0 || !import_typescripts5.Symbols.isClass(extendsSymbol2)) {
                throw new Error("No extends symbol found");
              }
              break;
            }
          }
          if (extendsSymbol2 === void 0) {
            throw new Error("No extends symbol found");
          }
          this.extendsSymbol = extendsSymbol2;
        } else {
          super(program, symbols, declaration, stateProvider);
          this.classDeclaration = classDeclarationOrSearch;
          this.extendsSymbol = extendsSymbol;
        }
      }
      run(context, token) {
        const memberName = this.getMemberName();
        for (const subType of this.symbols.getDirectSubTypes(this.extendsSymbol, context.getPreferredNeighborFiles(this.program), this.stateProvider, token)) {
          token.throwIfCancellationRequested();
          if (subType.members !== void 0) {
            const member = subType.members.get(memberName);
            if (member === void 0) {
              continue;
            }
            const declarations = member.declarations;
            if (declarations === void 0 || declarations.length === 0) {
              continue;
            }
            for (const declaration of declarations) {
              if (declaration.kind !== this.declaration.kind) {
                continue;
              }
              const parent = declaration.parent;
              if (!ts5.isClassDeclaration(parent) || parent === this.classDeclaration) {
                continue;
              }
              return parent;
            }
          }
        }
        return void 0;
      }
    };
    PrivateMethodBlueprintSearch = class _PrivateMethodBlueprintSearch extends FindInSiblingClassSearch {
      constructor(program, symbols, classDeclarationOrSearch, extendsSymbol, declaration, stateProvider) {
        if (classDeclarationOrSearch instanceof _PrivateMethodBlueprintSearch) {
          super(program, symbols, classDeclarationOrSearch);
        } else {
          super(program, symbols, classDeclarationOrSearch, extendsSymbol, declaration, stateProvider);
        }
      }
      with(program) {
        if (program === this.program) {
          return this;
        }
        return new _PrivateMethodBlueprintSearch(program, new import_typescripts5.Symbols(program), this);
      }
      getMemberName() {
        return ts5.escapeLeadingUnderscores(this.declaration.name.getText());
      }
    };
    FindMethodInSubclassSearch = class _FindMethodInSubclassSearch extends MethodBlueprintSearch {
      classDeclaration;
      startClass;
      constructor(program, symbols, classDeclarationOrSearch, declaration, startClass, stateProvider) {
        if (classDeclarationOrSearch instanceof _FindMethodInSubclassSearch) {
          const search = classDeclarationOrSearch;
          const declaration2 = Search.getNodeInProgram(program, search.declaration);
          super(program, symbols, declaration2, search.stateProvider);
          this.classDeclaration = Search.getNodeInProgram(program, search.classDeclaration);
          const startClass2 = search.startClass;
          const declarations = startClass2.declarations;
          if (declarations === void 0 || declarations.length === 0) {
            throw new RecoverableError("No declarations found for start class", RecoverableError.NoDeclaration);
          }
          let symbol;
          for (const declaration3 of declarations) {
            if (!ts5.isClassDeclaration(declaration3)) {
              continue;
            }
            symbol = this.symbols.getLeafSymbolAtLocation(declaration3.name ? declaration3.name : declaration3);
            if (symbol !== void 0) {
              break;
            }
          }
          if (symbol === void 0) {
            throw new RecoverableError("No symbol found for start class", RecoverableError.SymbolNotFound);
          }
          this.startClass = symbol;
        } else {
          super(program, symbols, declaration, stateProvider);
          this.classDeclaration = classDeclarationOrSearch;
          this.startClass = startClass;
        }
      }
      with(program) {
        if (program === this.program) {
          return this;
        }
        return new _FindMethodInSubclassSearch(program, new import_typescripts5.Symbols(program), this);
      }
      run(context, token) {
        if (!import_typescripts5.Symbols.isClass(this.startClass)) {
          return void 0;
        }
        const callableName = ts5.escapeLeadingUnderscores(this.declaration.name.getText());
        for (const subType of this.symbols.getAllSubTypes(this.startClass, import_typescripts5.Traversal.breadthFirst, context.getPreferredNeighborFiles(this.program), this.stateProvider, token)) {
          token.throwIfCancellationRequested();
          if (subType.members !== void 0) {
            const member = subType.members.get(callableName);
            if (member === void 0) {
              continue;
            }
            const declarations = member.declarations;
            if (declarations === void 0 || declarations.length === 0) {
              continue;
            }
            for (const declaration of declarations) {
              if (!ts5.isMethodDeclaration(declaration)) {
                continue;
              }
              const parent = declaration.parent;
              if (!ts5.isClassDeclaration(parent) || parent === this.classDeclaration) {
                continue;
              }
              return parent;
            }
          }
        }
        return void 0;
      }
    };
    FindMethodInHierarchySearch = class _FindMethodInHierarchySearch extends MethodBlueprintSearch {
      classDeclaration;
      typesToCheck;
      constructor(program, symbols, classDeclarationOrSearch, declaration, typesToCheck, stateProvider) {
        if (classDeclarationOrSearch instanceof _FindMethodInHierarchySearch) {
          const search = classDeclarationOrSearch;
          const declaration2 = Search.getNodeInProgram(program, search.declaration);
          super(program, symbols, declaration2, search.stateProvider);
          this.classDeclaration = Search.getNodeInProgram(program, search.classDeclaration);
          const typesToCheck2 = [];
          for (const symbolToCheck of search.typesToCheck) {
            const declarations = symbolToCheck.declarations;
            if (declarations === void 0 || declarations.length === 0) {
              throw new RecoverableError("No declarations found for start class", RecoverableError.NoDeclaration);
            }
            let symbol;
            for (const declaration3 of declarations) {
              if (!ts5.isClassDeclaration(declaration3) && !ts5.isInterfaceDeclaration(declaration3)) {
                continue;
              }
              symbol = this.symbols.getLeafSymbolAtLocation(declaration3.name ? declaration3.name : declaration3);
              if (symbol !== void 0 && symbol.flags === symbolToCheck.flags) {
                break;
              }
            }
            if (symbol === void 0) {
              throw new RecoverableError("No symbol found for start class", RecoverableError.SymbolNotFound);
            }
            typesToCheck2.push(symbol);
          }
          this.typesToCheck = typesToCheck2;
        } else {
          super(program, symbols, declaration, stateProvider);
          this.classDeclaration = classDeclarationOrSearch;
          this.typesToCheck = typesToCheck;
        }
      }
      with(program) {
        if (program === this.program) {
          return this;
        }
        return new _FindMethodInHierarchySearch(program, new import_typescripts5.Symbols(program), this);
      }
      run(context, token) {
        const callableName = ts5.escapeLeadingUnderscores(this.declaration.name.getText());
        const startSet = new Set(this.typesToCheck);
        const queue = [];
        for (const toCheck of this.typesToCheck) {
          token.throwIfCancellationRequested();
          for (const subType of this.symbols.getDirectSubTypes(toCheck, context.getPreferredNeighborFiles(this.program), this.stateProvider, token)) {
            token.throwIfCancellationRequested();
            if (startSet.has(subType)) {
              continue;
            }
            if (import_typescripts5.Symbols.isClass(subType)) {
              const member = subType.members?.get(callableName);
              if (member !== void 0 && !import_typescripts5.Symbols.isAbstract(member)) {
                const declaration = import_typescripts5.ClassDeclarations.fromSymbol(subType);
                if (declaration === this.classDeclaration) {
                  continue;
                }
                if (declaration !== void 0) {
                  return declaration;
                }
              }
            }
            queue.push(subType);
          }
        }
        const seen = /* @__PURE__ */ new Set();
        for (const symbol of queue) {
          token.throwIfCancellationRequested();
          if (seen.has(symbol)) {
            continue;
          }
          for (const subType of this.symbols.getAllSubTypes(symbol, import_typescripts5.Traversal.breadthFirst, context.getPreferredNeighborFiles(this.program), this.stateProvider, token)) {
            token.throwIfCancellationRequested();
            if (seen.has(subType)) {
              continue;
            }
            if (import_typescripts5.Symbols.isClass(subType)) {
              const member = subType.members?.get(callableName);
              if (member !== void 0 && !import_typescripts5.Symbols.isAbstract(member)) {
                const declaration = import_typescripts5.ClassDeclarations.fromSymbol(subType);
                if (declaration === this.classDeclaration) {
                  seen.add(subType);
                  continue;
                }
                if (declaration !== void 0) {
                  return declaration;
                }
              }
            }
            seen.add(subType);
          }
          seen.add(symbol);
        }
        return void 0;
      }
    };
    SimilarPropertyRunnable = class extends FunctionLikeContextRunnable {
      constructor(session, languageService, context, declaration, priority = 0.6 /* Blueprints */) {
        super(session, languageService, context, "SimilarPropertyRunnable", declaration, priority, 3 /* High */);
      }
      createRunnableResult(result) {
        const scope = this.getCacheScope();
        const cacheInfo = scope !== void 0 ? { emitMode: "clientBased" /* ClientBased */, scope } : void 0;
        return result.createRunnableResult(this.id, this.priority, "emit" /* emit */, cacheInfo);
      }
      run(result, token) {
        const search = this.createSearch(token);
        if (search !== void 0) {
          const [program, candidate] = this.session.run(search, this.context, token);
          if (program !== void 0 && candidate !== void 0) {
            const symbol = this.symbols.getLeafSymbolAtLocation(candidate.name ? candidate.name : candidate);
            if (symbol === void 0) {
              return;
            }
            const sourceFile = this.declaration.getSourceFile();
            const snippetBuilder = new CodeSnippetBuilder(this.context, this.context.getSymbols(program), sourceFile);
            snippetBuilder.addDeclaration(candidate);
            result.addSnippet(snippetBuilder, this.location, void 0);
          }
        }
      }
    };
    SimilarMethodRunnable = class extends SimilarPropertyRunnable {
      constructor(session, languageService, context, declaration) {
        super(session, languageService, context, declaration);
      }
      createSearch() {
        return MethodBlueprintSearch.create(this.getProgram(), this.symbols, this.declaration, this.session);
      }
    };
    ClassPropertyContextProvider = class extends FunctionLikeContextProvider {
      declaration;
      isCallableProvider;
      constructor(declaration, tokenInfo, computeContext2) {
        super(declaration, tokenInfo, computeContext2);
        this.declaration = declaration;
        this.isCallableProvider = true;
      }
      getTypeExcludes(languageService, context) {
        const result = /* @__PURE__ */ new Set();
        const classDeclaration = this.declaration.parent;
        if (ts5.isClassDeclaration(classDeclaration) && classDeclaration.heritageClauses !== void 0 && classDeclaration.heritageClauses.length > 0) {
          const program = languageService.getProgram();
          if (program !== void 0) {
            const symbols = context.getSymbols(program);
            for (const heritageClause of classDeclaration.heritageClauses) {
              if (heritageClause.token !== ts5.SyntaxKind.ExtendsKeyword) {
                continue;
              }
              for (const type of heritageClause.types) {
                const symbol = symbols.getLeafSymbolAtLocation(type.expression);
                if (symbol !== void 0 && import_typescripts5.Symbols.isClass(symbol)) {
                  return result.add(symbol);
                }
              }
            }
          }
        }
        return result;
      }
    };
    PropertiesTypeRunnable = class _PropertiesTypeRunnable extends AbstractContextRunnable {
      declaration;
      constructor(session, languageService, context, declaration, priority = 0.5 /* Properties */) {
        super(session, languageService, context, "PropertiesTypeRunnable", 1 /* Secondary */, priority, 2 /* Medium */);
        this.declaration = declaration;
      }
      getActiveSourceFile() {
        return this.declaration.getSourceFile();
      }
      createRunnableResult(result) {
        const cacheInfo = { emitMode: "clientBased" /* ClientBased */, scope: this.createCacheScope(this.declaration) };
        return result.createRunnableResult(this.id, this.priority, "emit" /* emit */, cacheInfo);
      }
      run(result, token) {
        const containerDeclaration = this.declaration.parent;
        if (!ts5.isClassDeclaration(containerDeclaration)) {
          return;
        }
        const program = this.getProgram();
        const symbols = this.context.getSymbols(program);
        const containerSymbol = symbols.getLeafSymbolAtLocation(containerDeclaration.name ? containerDeclaration.name : containerDeclaration);
        if (containerSymbol === void 0 || !import_typescripts5.Symbols.isClass(containerSymbol)) {
          return;
        }
        if (containerSymbol.members !== void 0) {
          for (const member of containerSymbol.members.values()) {
            token.throwIfCancellationRequested();
            if (!this.handleMember(result, member, symbols, ts5.ModifierFlags.Private | ts5.ModifierFlags.Protected)) {
              return;
            }
          }
        }
        for (const type of symbols.getAllSuperClasses(containerSymbol)) {
          token.throwIfCancellationRequested();
          if (type.members === void 0) {
            continue;
          }
          for (const member of type.members.values()) {
            token.throwIfCancellationRequested();
            if (!this.handleMember(result, member, symbols, ts5.ModifierFlags.Public | ts5.ModifierFlags.Protected)) {
              return;
            }
          }
        }
      }
      handleMember(_result, symbol, symbols, flags) {
        if (!import_typescripts5.Symbols.hasModifierFlags(symbol, flags)) {
          return true;
        }
        let continueResult = true;
        for (const [typeSymbol, name] of this.getEmitMemberData(symbol, symbols)) {
          if (typeSymbol === void 0) {
            continue;
          }
          continueResult = continueResult && this.handleSymbol(typeSymbol, name, true);
          if (!continueResult) {
            break;
          }
        }
        return continueResult;
      }
      static NoEmitData = Object.freeze([void 0, void 0]);
      *getEmitMemberData(symbol, symbols) {
        if (import_typescripts5.Symbols.isProperty(symbol)) {
          const type = symbols.getTypeChecker().getTypeOfSymbol(symbol);
          let typeSymbol = type.symbol;
          if (typeSymbol === void 0) {
            return;
          }
          typeSymbol = symbols.getLeafSymbol(typeSymbol);
          let name = void 0;
          const declaration = import_typescripts5.Symbols.getDeclaration(symbol, ts5.SyntaxKind.PropertyDeclaration);
          if (declaration !== void 0) {
            if (declaration.type !== void 0) {
              name = import_typescripts5.default.Nodes.getTypeName(declaration.type);
            }
          }
          yield [typeSymbol, name];
          return;
        } else if (import_typescripts5.Symbols.isMethod(symbol)) {
          const type = symbols.getTypeChecker().getTypeOfSymbol(symbol);
          const signatures = type.getCallSignatures();
          if (signatures.length === 0) {
            return;
          }
          for (const signature of signatures) {
            let typeSymbol = signature.getReturnType().symbol;
            if (typeSymbol === void 0) {
              yield _PropertiesTypeRunnable.NoEmitData;
            }
            typeSymbol = symbols.getLeafSymbol(typeSymbol);
            let name = void 0;
            const declaration = signature.getDeclaration();
            if (declaration !== void 0) {
              if (declaration.type !== void 0) {
                name = import_typescripts5.default.Nodes.getTypeName(declaration.type);
              }
            }
            yield [typeSymbol, name];
          }
        }
        return;
      }
    };
    MethodContextProvider = class extends ClassPropertyContextProvider {
      constructor(declaration, tokenInfo, computeContext2) {
        super(declaration, tokenInfo, computeContext2);
      }
      provide(result, session, languageService, context, token) {
        if (session.enableBlueprintSearch()) {
          result.addPrimary(new SimilarMethodRunnable(session, languageService, context, this.declaration));
        }
        super.provide(result, session, languageService, context, token);
        result.addSecondary(new PropertiesTypeRunnable(session, languageService, context, this.declaration));
      }
    };
    AccessorProvider = class extends ClassPropertyContextProvider {
      constructor(declaration, tokenInfo, computeContext2) {
        super(declaration, tokenInfo, computeContext2);
      }
      provide(result, session, languageService, context, token) {
        super.provide(result, session, languageService, context, token);
        result.addSecondary(new PropertiesTypeRunnable(session, languageService, context, this.declaration));
      }
    };
    ConstructorBlueprintSearch = class _ConstructorBlueprintSearch extends FindInSiblingClassSearch {
      constructor(program, symbols, classDeclarationOrSearch, extendsSymbol, declaration, stateProvider) {
        if (classDeclarationOrSearch instanceof _ConstructorBlueprintSearch) {
          super(program, symbols, classDeclarationOrSearch);
        } else {
          super(program, symbols, classDeclarationOrSearch, extendsSymbol, declaration, stateProvider);
        }
      }
      with(program) {
        if (program === this.program) {
          return this;
        }
        return new _ConstructorBlueprintSearch(program, new import_typescripts5.Symbols(program), this);
      }
      getMemberName() {
        return ts5.InternalSymbolName.Constructor;
      }
    };
    SimilarConstructorRunnable = class extends SimilarPropertyRunnable {
      constructor(session, languageService, context, declaration) {
        super(session, languageService, context, declaration);
      }
      createSearch() {
        const classDeclaration = this.declaration.parent;
        if (!ts5.isClassDeclaration(classDeclaration)) {
          return void 0;
        }
        const extendsClause = import_typescripts5.ClassDeclarations.getExtendsClause(classDeclaration);
        if (extendsClause === void 0 || extendsClause.types.length === 0) {
          return void 0;
        } else {
          const extendsSymbol = this.symbols.getLeafSymbolAtLocation(extendsClause.types[0].expression);
          if (extendsSymbol === void 0 || !import_typescripts5.Symbols.isClass(extendsSymbol)) {
            return void 0;
          }
          return new ConstructorBlueprintSearch(this.getProgram(), this.symbols, classDeclaration, extendsSymbol, this.declaration, this.session);
        }
      }
    };
    ConstructorContextProvider = class extends ClassPropertyContextProvider {
      constructor(declaration, tokenInfo, computeContext2) {
        super(declaration, tokenInfo, computeContext2);
      }
      provide(result, session, languageService, context, token) {
        if (session.enableBlueprintSearch()) {
          result.addPrimary(new SimilarConstructorRunnable(session, languageService, context, this.declaration));
        }
        super.provide(result, session, languageService, context, token);
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/moduleContextProvider.ts
var ModuleContextProvider;
var init_moduleContextProvider = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/moduleContextProvider.ts"() {
    "use strict";
    init_baseContextProviders();
    init_contextProvider();
    ModuleContextProvider = class extends ContextProvider {
      declaration;
      tokenInfo;
      computeInfo;
      isCallableProvider;
      constructor(declaration, tokenInfo, computeInfo) {
        super();
        this.declaration = declaration;
        this.tokenInfo = tokenInfo;
        this.computeInfo = computeInfo;
        this.isCallableProvider = true;
      }
      provide(result, session, languageService, context, token) {
        token.throwIfCancellationRequested();
        if (!this.computeInfo.isFirstCallableProvider(this)) {
          return;
        }
        const excludes = /* @__PURE__ */ new Set();
        result.addPrimary(new TypeOfLocalsRunnable(session, languageService, context, this.tokenInfo, excludes, void 0));
        const runnable = TypeOfExpressionRunnable.create(session, languageService, context, this.tokenInfo, token);
        if (runnable !== void 0) {
          result.addPrimary(runnable);
        }
        result.addSecondary(new ImportsRunnable(session, languageService, context, this.tokenInfo, excludes, void 0));
        if (context.neighborFiles.length > 0) {
          result.addTertiary(new TypesOfNeighborFilesRunnable(session, languageService, context, this.tokenInfo, void 0));
        }
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/sourceFileContextProvider.ts
var ts6, GlobalsRunnable, SourceFileContextProvider;
var init_sourceFileContextProvider = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/sourceFileContextProvider.ts"() {
    "use strict";
    init_typescript();
    init_baseContextProviders();
    init_contextProvider();
    init_protocol();
    ts6 = typescript_default();
    GlobalsRunnable = class extends AbstractContextRunnable {
      tokenInfo;
      constructor(session, languageService, context, tokenInfo) {
        super(session, languageService, context, "GlobalsRunnable", 1 /* Secondary */, 0.2 /* Globals */, 2 /* Medium */);
        this.tokenInfo = tokenInfo;
      }
      getActiveSourceFile() {
        return this.tokenInfo.token.getSourceFile();
      }
      createRunnableResult(result) {
        return result.createRunnableResult(this.id, this.priority, "emit" /* emit */, { emitMode: "clientBased" /* ClientBased */, scope: { kind: "file" /* File */ } });
      }
      run(_result, token) {
        const symbols = this.symbols;
        const sourceFile = this.tokenInfo.token.getSourceFile();
        const inScope = this.getSymbolsInScope(symbols.getTypeChecker(), sourceFile);
        token.throwIfCancellationRequested();
        for (const symbol of inScope) {
          token.throwIfCancellationRequested();
          if (!this.handleSymbol(symbol, void 0, true)) {
            break;
          }
        }
      }
      getSymbolsInScope(typeChecker, sourceFile) {
        const result = [];
        const symbols = typeChecker.getSymbolsInScope(sourceFile, ts6.SymbolFlags.Function | ts6.SymbolFlags.Class | ts6.SymbolFlags.Interface | ts6.SymbolFlags.TypeAlias | ts6.SymbolFlags.ValueModule);
        for (const symbol of symbols) {
          if (this.skipSymbolBasedOnDeclaration(symbol)) {
            continue;
          }
          result.push(this.symbols.getLeafSymbol(symbol));
        }
        return result;
      }
    };
    SourceFileContextProvider = class extends ContextProvider {
      tokenInfo;
      computeInfo;
      isCallableProvider;
      constructor(tokenInfo, computeInfo) {
        super();
        this.tokenInfo = tokenInfo;
        this.computeInfo = computeInfo;
        this.isCallableProvider = true;
      }
      provide(result, session, languageService, context, token) {
        token.throwIfCancellationRequested();
        result.addSecondary(new GlobalsRunnable(session, languageService, context, this.tokenInfo));
        if (!this.computeInfo.isFirstCallableProvider(this)) {
          return;
        }
        result.addPrimary(new TypeOfLocalsRunnable(session, languageService, context, this.tokenInfo, /* @__PURE__ */ new Set(), void 0));
        const runnable = TypeOfExpressionRunnable.create(session, languageService, context, this.tokenInfo, token);
        if (runnable !== void 0) {
          result.addPrimary(runnable);
        }
        result.addSecondary(new ImportsRunnable(session, languageService, context, this.tokenInfo, /* @__PURE__ */ new Set(), void 0));
        if (context.neighborFiles.length > 0) {
          result.addTertiary(new TypesOfNeighborFilesRunnable(session, languageService, context, this.tokenInfo));
        }
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/common/api.ts
function computeContext(result, session, languageService, document, position, token) {
  const program = languageService.getProgram();
  if (program === void 0) {
    result.addErrorData(new RecoverableError(`No program found on language service`, RecoverableError.NoProgram));
    return;
  }
  const sourceFile = program.getSourceFile(document);
  if (sourceFile === void 0) {
    result.addErrorData(new RecoverableError(`No source file found for document`, RecoverableError.NoSourceFile));
    return;
  }
  const tokenInfo = import_typescripts6.default.getRelevantTokens(sourceFile, position);
  const providers = new ContextProviders(tokenInfo);
  providers.execute(result, session, languageService, token);
}
var import_typescripts6, ts7, ProviderComputeContextImpl, ContextProviders;
var init_api = __esm({
  "src/extension/typescriptContext/serverPlugin/src/common/api.ts"() {
    "use strict";
    init_typescript();
    init_baseContextProviders();
    init_classContextProvider();
    init_contextProvider();
    init_functionContextProvider();
    init_methodContextProvider();
    init_moduleContextProvider();
    init_sourceFileContextProvider();
    init_types();
    import_typescripts6 = __toESM(require_typescripts());
    ts7 = typescript_default();
    ProviderComputeContextImpl = class {
      firstCallableProvider;
      constructor() {
        this.firstCallableProvider = void 0;
      }
      update(contextProvider) {
        if (this.firstCallableProvider === void 0 && contextProvider.isCallableProvider !== void 0 && contextProvider.isCallableProvider === true) {
          this.firstCallableProvider = contextProvider;
        }
        return contextProvider;
      }
      isFirstCallableProvider(contextProvider) {
        return this.firstCallableProvider === contextProvider;
      }
    };
    ContextProviders = class _ContextProviders {
      static Factories = /* @__PURE__ */ new Map([
        [ts7.SyntaxKind.SourceFile, (_node, tokenInfo, computeContext2) => new SourceFileContextProvider(tokenInfo, computeContext2)],
        [ts7.SyntaxKind.FunctionDeclaration, (node, tokenInfo, computeContext2) => new FunctionContextProvider(node, tokenInfo, computeContext2)],
        [ts7.SyntaxKind.ArrowFunction, (node, tokenInfo, computeContext2) => new FunctionContextProvider(node, tokenInfo, computeContext2)],
        [ts7.SyntaxKind.FunctionExpression, (node, tokenInfo, computeContext2) => new FunctionContextProvider(node, tokenInfo, computeContext2)],
        [ts7.SyntaxKind.GetAccessor, (node, tokenInfo, computeContext2) => new AccessorProvider(node, tokenInfo, computeContext2)],
        [ts7.SyntaxKind.SetAccessor, (node, tokenInfo, computeContext2) => new AccessorProvider(node, tokenInfo, computeContext2)],
        [ts7.SyntaxKind.ClassDeclaration, ClassContextProvider.create],
        [ts7.SyntaxKind.Constructor, (node, tokenInfo, computeContext2) => new ConstructorContextProvider(node, tokenInfo, computeContext2)],
        [ts7.SyntaxKind.MethodDeclaration, (node, tokenInfo, computeContext2) => new MethodContextProvider(node, tokenInfo, computeContext2)],
        [ts7.SyntaxKind.ModuleDeclaration, (node, tokenInfo, computeContext2) => new ModuleContextProvider(node, tokenInfo, computeContext2)]
      ]);
      tokenInfo;
      computeInfo;
      constructor(tokenInfo) {
        this.tokenInfo = tokenInfo;
        this.computeInfo = new ProviderComputeContextImpl();
      }
      execute(result, session, languageService, token) {
        const collector = this.getContextRunnables(session, languageService, result.context, token);
        result.addPath(import_typescripts6.default.StableSyntaxKinds.getPath(this.tokenInfo.touching ?? this.tokenInfo.token));
        for (const runnable of collector.entries()) {
          runnable.initialize(result);
        }
        this.executeRunnables(collector.getPrimaryRunnables(), result, token);
        this.executeRunnables(collector.getSecondaryRunnables(), result, token);
        this.executeRunnables(collector.getTertiaryRunnables(), result, token);
        result.done();
      }
      executeRunnables(runnables, result, token) {
        for (const runnable of runnables) {
          token.throwIfCancellationRequested();
          try {
            runnable.compute(token);
          } catch (error) {
            if (error instanceof RecoverableError) {
              result.addErrorData(error);
            } else {
              throw error;
            }
          }
        }
      }
      getContextRunnables(session, languageService, context, token) {
        const result = new ContextRunnableCollector(context.clientSideRunnableResults);
        result.addPrimary(new CompilerOptionsRunnable(session, languageService, context, this.tokenInfo.token.getSourceFile()));
        const providers = this.computeProviders();
        for (const provider of providers) {
          provider.provide(result, session, languageService, context, token);
        }
        return result;
      }
      computeProviders() {
        const result = [];
        let token = this.tokenInfo.touching;
        if (token === void 0) {
          if (this.tokenInfo.token === void 0 || this.tokenInfo.token.kind === ts7.SyntaxKind.EndOfFileToken) {
            token = this.tokenInfo.previous;
          } else {
            token = this.tokenInfo.token;
          }
        }
        if (token === void 0 || token.kind === ts7.SyntaxKind.EndOfFileToken) {
          return result;
        }
        let current = token;
        while (current !== void 0) {
          const factory = _ContextProviders.Factories.get(current.kind);
          if (factory !== void 0) {
            const provider = factory(current, this.tokenInfo, this.computeInfo);
            if (provider !== void 0) {
              result.push(this.computeInfo.update(provider));
            }
          }
          current = current.parent;
        }
        return result;
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/node/host.ts
var import_crypto, NodeHost;
var init_host = __esm({
  "src/extension/typescriptContext/serverPlugin/src/node/host.ts"() {
    "use strict";
    import_crypto = __toESM(require("crypto"));
    NodeHost = class {
      constructor() {
      }
      createHash(algorithm) {
        return import_crypto.default.createHash(algorithm);
      }
      isDebugging() {
        return process.execArgv.some((arg) => /^--(?:inspect|debug)(?:-brk)?(?:=\d+)?$/i.test(arg));
      }
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/node/create.ts
var create_exports = {};
__export(create_exports, {
  create: () => create
});
function create(info) {
  if (installAttempted) {
    return info.languageService;
  }
  if (info.session !== void 0) {
    try {
      info.session.addProtocolHandler("_.copilot.ping", () => {
        return { response: pingResult, responseRequired: true };
      });
      try {
        const versionSupported = isSupportedVersion();
        pingResult = { kind: "ok", session: true, supported: versionSupported, version: ts8.version };
        if (versionSupported) {
          computeContextSession = new LanguageServerSession(info.session, new NodeHost());
          languageServiceHost = info.languageServiceHost;
          info.session.addProtocolHandler("_.copilot.context", computeContextHandler);
        }
      } catch (e) {
        if (e instanceof Error) {
          pingResult = { kind: "error", message: e.message, stack: e.stack };
          info.session.logError(e, "_.copilot.installHandler");
        } else {
          pingResult = { kind: "error", message: "Unknown error" };
          info.session.logError(new Error("Unknown error"), "_.copilot.installHandler");
        }
      }
    } catch (error) {
      if (error instanceof Error) {
        info.session.logError(error, "_.copilot.installPingHandler");
      } else {
        info.session.logError(new Error("Unknown error"), "_.copilot.installPingHandler");
      }
    } finally {
      installAttempted = true;
    }
  }
  return info.languageService;
}
function isSupportedVersion() {
  try {
    const version = ts8.versionMajorMinor.split(".");
    if (version.length < 2) {
      return false;
    }
    const major = parseInt(version[0]);
    const minor = parseInt(version[1]);
    return major > 5 || major === 5 && minor >= 5;
  } catch (e) {
    return false;
  }
}
var import_typescripts7, ts8, installAttempted, computeContextSession, languageServiceHost, pingResult, computeContextHandler;
var init_create = __esm({
  "src/extension/typescriptContext/serverPlugin/src/node/create.ts"() {
    "use strict";
    init_api();
    init_contextProvider();
    init_protocol();
    import_typescripts7 = __toESM(require_typescripts());
    init_typescript();
    init_host();
    ts8 = typescript_default();
    installAttempted = false;
    computeContextSession = void 0;
    languageServiceHost = void 0;
    pingResult = { kind: "error", message: "Attempt to install context handler failed" };
    computeContextHandler = (request) => {
      const totalStart = Date.now();
      if (request.arguments === void 0) {
        return { response: { error: "noArguments" /* noArguments */, message: "No arguments provided" }, responseRequired: true };
      }
      const args = request.arguments;
      const fileAndProject = computeContextSession?.getFileAndProject(args);
      if (fileAndProject === void 0) {
        return { response: { error: "noProject" /* noProject */, message: "No project found" }, responseRequired: true };
      }
      if (typeof args.line !== "number" || typeof args.offset !== "number") {
        return { response: { error: "invalidArguments" /* invalidArguments */, message: "No project found" }, responseRequired: true };
      }
      const { file, project } = fileAndProject;
      const pos = computeContextSession?.getPositionInFile(args, file);
      if (pos === void 0) {
        return { response: { error: "invalidPosition" /* invalidPosition */, message: "Position not valid" }, responseRequired: true };
      }
      let startTime = request.arguments?.startTime ?? totalStart;
      let timeBudget = typeof args.timeBudget === "number" ? args.timeBudget : 100;
      if (startTime + timeBudget > totalStart) {
        startTime = totalStart;
        timeBudget = 100;
      }
      const languageService = project.getLanguageService();
      const program = languageService.getProgram();
      if (program === void 0) {
        return { response: { error: "noProgram" /* noProgram */, message: "No program found" }, responseRequired: true };
      }
      const computeStart = Date.now();
      const primaryCharacterBudget = new CharacterBudget(typeof args.primaryCharacterBudget === "number" ? args.primaryCharacterBudget : 7 * 1024 * 4);
      const secondaryCharacterBudget = new CharacterBudget(typeof args.secondaryCharacterBudget === "number" ? args.secondaryCharacterBudget : 8 * 1024 * 4);
      const normalizedPaths = [];
      if (args.neighborFiles !== void 0) {
        for (const file2 of args.neighborFiles) {
          normalizedPaths.push(ts8.server.toNormalizedPath(file2));
        }
      }
      const clientSideRunnableResults = args.clientSideRunnableResults !== void 0 ? new Map(args.clientSideRunnableResults.map((item) => [item.id, item])) : /* @__PURE__ */ new Map();
      const cancellationToken = new import_typescripts7.CancellationTokenWithTimer(languageServiceHost?.getCancellationToken ? languageServiceHost.getCancellationToken() : void 0, startTime, timeBudget, computeContextSession?.host.isDebugging() ?? false);
      const requestContext = new RequestContext(computeContextSession, normalizedPaths, clientSideRunnableResults, !!args.includeDocumentation);
      const result = new ContextResult(primaryCharacterBudget, secondaryCharacterBudget, requestContext);
      try {
        computeContext(result, computeContextSession, languageService, file, pos, cancellationToken);
      } catch (error) {
        if (!(error instanceof ts8.OperationCanceledException) && !(error instanceof TokenBudgetExhaustedError)) {
          if (error instanceof Error) {
            return { response: { error: "exception" /* exception */, message: error.message, stack: error.stack }, responseRequired: true };
          } else {
            return { response: { error: "exception" /* exception */, message: "Unknown error" }, responseRequired: true };
          }
        }
      }
      const endTime = Date.now();
      result.addTimings(endTime - totalStart, endTime - computeStart);
      result.setTimedOut(cancellationToken.isTimedOut());
      return { response: result.toJson(), responseRequired: true };
    };
  }
});

// src/extension/typescriptContext/serverPlugin/src/node/main.ts
init_typescript();
var initCalled = false;
var create2 = void 0;
function init(module2) {
  if (!initCalled) {
    try {
      typescript_default.install(module2.typescript);
      create2 = (init_create(), __toCommonJS(create_exports)).create;
    } finally {
      initCalled = true;
    }
  }
  if (create2 === void 0) {
    throw new Error(`Couldn't initialize TypeScript Context Server Plugin.`);
  }
  return { create: create2 };
}
module.exports = init;
//# sourceMappingURL=main.js.map
